/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.ConstraintDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.parameter.ParameterDefinition;
import org.cafienne.cmmn.definition.sentry.IfPartDefinition;
import org.cafienne.cmmn.expression.CMMNExpressionEvaluator;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.parameter.TaskInputParameter;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.json.Value;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEvaluator
implements CMMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private final String jsonPath;
    private final ExpressionDefinition definition;

    public ExpressionEvaluator(ExpressionDefinition expressionDefinition) {
        this.jsonPath = expressionDefinition.getBody();
        this.definition = expressionDefinition;
    }

    public boolean evaluateConstraint(Case case_, Object object, String string) {
        case_.addDebugInfo(() -> "Now evaluating the expression " + this.jsonPath, new Object[0]);
        String string2 = String.valueOf(object);
        Object object2 = Configuration.defaultConfiguration().jsonProvider().parse(string2);
        boolean bl = Boolean.parseBoolean((String)JsonPath.read((Object)object2, (String)this.jsonPath, (Predicate[])new Predicate[0]));
        return bl;
    }

    @Override
    public Value<?> evaluateInputParameterTransformation(Case case_, TaskInputParameter taskInputParameter, ParameterDefinition parameterDefinition, Task<?> task) {
        return this.evaluateJSON(case_, taskInputParameter.getValue());
    }

    @Override
    public Value<?> evaluateOutputParameterTransformation(Case case_, Value<?> value, ParameterDefinition parameterDefinition, ParameterDefinition parameterDefinition2, Task<?> task) {
        return this.evaluateJSON(case_, value);
    }

    @Override
    public Value<?> evaluateOutputParameterTransformation(ProcessTaskActor processTaskActor, Value<?> value, ParameterDefinition parameterDefinition, ParameterDefinition parameterDefinition2) {
        return this.evaluateJSON(processTaskActor, value);
    }

    private Value<?> evaluateJSON(ModelActor modelActor, Value<?> value) {
        if (value == null || value.equals(Value.NULL)) {
            modelActor.addDebugInfo(() -> "Skipping the json path evaluation of expression " + this.jsonPath + ", because input value is null; returning Value.NULL", new Object[0]);
            return Value.NULL;
        }
        modelActor.addDebugInfo(() -> "Evaluating expression " + this.jsonPath + " on ", value);
        String string = String.valueOf(value);
        if (string.trim().isEmpty()) {
            modelActor.addDebugInfo(() -> "Skipping the json path evaluation of expression " + this.jsonPath + ", because input value is empty; returning Value.NULL", new Object[0]);
            return Value.NULL;
        }
        try {
            Object object;
            Object object2 = JsonPath.read((String)string, (String)this.jsonPath, (Predicate[])new Predicate[0]);
            Object object3 = Value.convert(object2);
            if (((Value)object3).isList() && ((Value)object3).asList().size() == 1) {
                object3 = ((Value)object3).asList().get(0);
                object = object3.getClass().getSimpleName();
                modelActor.addDebugInfo(() -> ExpressionEvaluator.lambda$evaluateJSON$4((String)object), new Object[0]);
            }
            object = object3;
            modelActor.addDebugInfo(() -> "Result of json evaluation: ", object);
            return object;
        }
        catch (InvalidJsonException invalidJsonException) {
            throw new InvalidExpressionException("Cannot evaluate json path", invalidJsonException.fillInStackTrace());
        }
        catch (JsonPathException jsonPathException) {
            String string2 = "The expression could not be resolved on the object due to a path exception - " + jsonPathException.getMessage();
            modelActor.addDebugInfo(() -> string2, new Object[0]);
            logger.warn(string2);
            return Value.NULL;
        }
    }

    @Override
    public boolean evaluateItemControl(PlanItem<?> planItem, ConstraintDefinition constraintDefinition) {
        return false;
    }

    @Override
    public boolean evaluateIfPart(Criterion<?> criterion, IfPartDefinition ifPartDefinition) {
        return false;
    }

    @Override
    public boolean evaluateApplicabilityRule(PlanItem<?> planItem, DiscretionaryItemDefinition discretionaryItemDefinition, ApplicabilityRuleDefinition applicabilityRuleDefinition) {
        return false;
    }

    private static /* synthetic */ Object lambda$evaluateJSON$4(String string) {
        return "Resulting array structure has only one element; returning element instead of array. Element has type " + string;
    }
}

