/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel.api.cmmn.file;

import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.expression.spel.api.APIObject;
import org.cafienne.cmmn.expression.spel.api.cmmn.file.ValueAPI;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemArray;

public class CaseFileItemAPI
extends APIObject<Case> {
    protected final CaseFileItem item;
    protected final CaseFileItemAPI parent;

    public CaseFileItemAPI(CaseFileItem caseFileItem) {
        super(caseFileItem.getCaseInstance());
        this.item = caseFileItem;
        this.parent = caseFileItem.getParent() == null ? null : new CaseFileItemAPI(caseFileItem.getParent());
        this.addPropertyReader("index", () -> caseFileItem.getIndex());
        this.addPropertyReader("value", this::getValue);
        this.addPropertyReader("container", () -> new CaseFileItemAPI((CaseFileItem)caseFileItem.getContainer()));
        this.addPropertyReader("current", () -> new CaseFileItemAPI(caseFileItem.getCurrent()));
        this.addPropertyReader("parent", () -> this.parent);
    }

    public Object get(int n) {
        if (((CaseFileItem)this.item.getContainer()).isArray()) {
            CaseFileItemArray caseFileItemArray = (CaseFileItemArray)this.item.getContainer();
            return new CaseFileItemAPI(caseFileItemArray.get(n)).getValue();
        }
        throw new InvalidExpressionException("Cannot read index " + n + " from non-array case file item " + this);
    }

    public Object getValue() {
        return new ValueAPI(this.item).getValue();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.item.getPath() + "]";
    }
}

