/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel.api.cmmn.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.definition.team.CaseTeamDefinition;
import org.cafienne.cmmn.expression.spel.api.APIObject;
import org.cafienne.cmmn.expression.spel.api.cmmn.team.BaseTeamAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.team.CaseRoleAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.team.MemberAPI;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.team.Team;

public class CaseTeamAPI
extends BaseTeamAPI {
    private final Map<String, CaseRoleAPI> rolesByName = new HashMap<String, CaseRoleAPI>();
    private final List<MemberAPI> members = new ArrayList<MemberAPI>();
    private final RoleAPI roleAPI = new RoleAPI((Case)((Object)this.getActor()));

    public CaseTeamAPI(Team team) {
        super(team);
        this.addPropertyReader("members", this::getMembers);
        this.addPropertyReader("users", this::getUsers);
        this.addPropertyReader("groups", this::getGroups);
        this.addPropertyReader("tenantRoles", this::getTenantRoles);
        this.addPropertyReader("owners", this::getOwners);
        this.addPropertyReader("roles", () -> this.getRolesByName().values());
        this.addPropertyReader("role", this::getRoleAPI);
    }

    private RoleAPI getRoleAPI() {
        this.roleAPI.initialize(this.getRolesByName());
        return this.roleAPI;
    }

    private Map<String, CaseRoleAPI> getRolesByName() {
        if (this.rolesByName.isEmpty()) {
            ((CaseTeamDefinition)this.team.getDefinition()).getCaseRoles().forEach(caseRoleDefinition -> this.rolesByName.put(caseRoleDefinition.getName(), new CaseRoleAPI(this.team, (CaseRoleDefinition)caseRoleDefinition)));
        }
        return this.rolesByName;
    }

    private Collection<MemberAPI> getUsers() {
        return this.team.getUsers().stream().map(this::wrap).collect(Collectors.toList());
    }

    private Collection<MemberAPI> getGroups() {
        return this.team.getGroups().stream().map(this::wrap).collect(Collectors.toList());
    }

    private Collection<MemberAPI> getTenantRoles() {
        return this.team.getTenantRoles().stream().map(this::wrap).collect(Collectors.toList());
    }

    private Collection<MemberAPI> getOwners() {
        return this.getMembers().stream().filter(MemberAPI::isOwner).collect(Collectors.toList());
    }

    private Collection<MemberAPI> getMembers() {
        return this.team.getMembers().stream().map(this::wrap).collect(Collectors.toList());
    }

    public String getMemberWithRole(String string) {
        this.warnDeprecation("getMemberWithRole(\"" + string + "\")", "team.role[\"" + string + "\"].member");
        return this.team.getMemberWithRole(string);
    }

    class RoleAPI
    extends APIObject<Case> {
        boolean initialized;

        protected RoleAPI(Case case_) {
            super(case_);
        }

        public void initialize(Map<String, CaseRoleAPI> map) {
            if (this.initialized) {
                return;
            }
            map.forEach((string, caseRoleAPI) -> this.addPropertyReader((String)string, () -> caseRoleAPI));
        }
    }
}

