/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import org.cafienne.cmmn.actorapi.event.CaseEvent;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.debug.DebugInfoAppender;

public class CMMNElement<T extends DefinitionElement> {
    private final Case caseInstance;
    private T definition;
    private T previousDefinition;

    protected CMMNElement() {
        this.caseInstance = null;
        this.definition = null;
    }

    protected CMMNElement(Case case_, T t) {
        this.caseInstance = case_;
        this.definition = t;
    }

    protected CMMNElement(CMMNElement<?> cMMNElement, T t) {
        this.caseInstance = cMMNElement.caseInstance;
        this.definition = t;
    }

    protected void addDebugInfo(DebugInfoAppender debugInfoAppender, Object ... objectArray) {
        this.getCaseInstance().addDebugInfo(debugInfoAppender, objectArray);
    }

    public T getDefinition() {
        return this.definition;
    }

    public T getPreviousDefinition() {
        return this.previousDefinition;
    }

    public void migrateDefinition(T t, boolean bl) {
        this.previousDefinition = this.definition;
        this.definition = t;
    }

    protected boolean hasNewDefinition() {
        return this.previousDefinition != null && this.definition.differs(this.previousDefinition);
    }

    public Case getCaseInstance() {
        return this.caseInstance;
    }

    public String toString() {
        return super.toString();
    }

    protected <T extends CaseEvent> T addEvent(T t) {
        return this.getCaseInstance().addEvent(t);
    }
}

