/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.Collection;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public class DiscretionaryItem
extends CMMNElement<DiscretionaryItemDefinition> {
    private final PlanItem<?> containingPlanItem;
    private final Stage<?> containingStage;

    public DiscretionaryItem(PlanItem<?> planItem, DiscretionaryItemDefinition discretionaryItemDefinition) {
        super(planItem, discretionaryItemDefinition);
        this.containingPlanItem = planItem;
        this.containingStage = this.containingPlanItem instanceof Stage ? (Stage<?>)this.containingPlanItem : this.containingPlanItem.getStage();
    }

    public boolean isPlannable() {
        boolean bl = ((DiscretionaryItemDefinition)this.getDefinition()).isPlanningAllowed((PlanItem)this.containingPlanItem);
        boolean bl2 = ((DiscretionaryItemDefinition)this.getDefinition()).isApplicable(this.containingPlanItem);
        return bl && bl2;
    }

    public Collection<CaseRoleDefinition> getAuthorizedRoles() {
        return ((DiscretionaryItemDefinition)this.getDefinition()).getAuthorizedRoles();
    }

    public boolean isAuthorized() {
        return this.getCaseInstance().getCurrentTeamMember().hasRoles(this.getAuthorizedRoles());
    }

    public void plan(String string) {
        this.containingStage.planChild(this, string);
    }

    public ValueMap asJson() {
        DiscretionaryItemDefinition discretionaryItemDefinition = (DiscretionaryItemDefinition)this.getDefinition();
        String string = discretionaryItemDefinition.getName();
        String string2 = discretionaryItemDefinition.getId();
        PlanItemType planItemType = discretionaryItemDefinition.getPlanItemDefinition().getItemType();
        String string3 = this.containingPlanItem.getName();
        PlanItemType planItemType2 = this.containingPlanItem.getType();
        String string4 = this.containingPlanItem.getId();
        return new ValueMap(new Object[]{Fields.name, string, Fields.definitionId, string2, Fields.type, planItemType, Fields.parentName, string3, Fields.parentType, planItemType2, Fields.parentId, string4});
    }
}

