/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.Collection;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemMigrated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.actorapi.event.plan.RepetitionRuleEvaluated;
import org.cafienne.cmmn.actorapi.event.plan.RequiredRuleEvaluated;
import org.cafienne.cmmn.definition.ConstraintDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.CasePlan;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.PlanItemEntry;
import org.cafienne.cmmn.instance.PlanItemExit;
import org.cafienne.cmmn.instance.PlanItemReactivator;
import org.cafienne.cmmn.instance.PlanItemTransitionPublisher;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.StateMachine;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.sentry.PlanItemOnPart;
import org.cafienne.cmmn.instance.sentry.TransitionGenerator;
import org.w3c.dom.Element;

public abstract class PlanItem<T extends PlanItemDefinitionDefinition>
extends CMMNElement<T>
implements TransitionGenerator<PlanItemTransitioned> {
    private final String id;
    private final int index;
    private final Path path;
    private final Stage<?> stage;
    private ItemDefinition itemDefinition;
    private ItemDefinition previousItemDefinition;
    private final StateMachine stateMachine;
    private final PlanItemEntry entryCriteria;
    private final PlanItemReactivator reactivators;
    private final PlanItemExit exitCriteria;
    private boolean repetitionRuleOutcome;
    private boolean requiredRuleOutcome;
    private final PlanItemTransitionPublisher transitionPublisher = new PlanItemTransitionPublisher(this);
    private Transition lastTransition = Transition.None;
    private State state = State.Null;
    private State historyState = State.Null;
    private Transition nextTransition = Transition.None;

    protected PlanItem(String string, int n, ItemDefinition itemDefinition, T t, Stage<?> stage, StateMachine stateMachine) {
        this(string, n, itemDefinition, t, stage.getCaseInstance(), stage, stateMachine);
    }

    protected PlanItem(String string, int n, ItemDefinition itemDefinition, T t, Case case_, Stage<?> stage, StateMachine stateMachine) {
        super(case_, t);
        this.id = string;
        this.itemDefinition = itemDefinition;
        this.stage = stage;
        this.index = n;
        this.path = new Path(this);
        this.stateMachine = stateMachine;
        this.entryCriteria = new PlanItemEntry(this);
        this.reactivators = new PlanItemReactivator(this);
        this.exitCriteria = new PlanItemExit(this);
        this.addDebugInfo(() -> "Constructing plan item " + this + " with id " + string + (String)(this.getStage() == null ? " in case" : " in " + this.getStage()), new Object[0]);
        this.getCaseInstance().registerPlanItem(this);
        if (this.getStage() != null) {
            this.getStage().register(this);
        }
        if (this.getCaseInstance().recoveryRunning()) {
            this.startListening();
        }
    }

    void create() {
        this.addDebugInfo(() -> "Connecting plan item " + this + " with id " + this.id + " to the sentry network", new Object[0]);
        this.startListening();
        this.makeTransition(Transition.Create);
    }

    private void startListening() {
        this.getCaseInstance().getSentryNetwork().connect(this);
        this.entryCriteria.startListening();
        this.reactivators.startListening();
        this.exitCriteria.startListening();
    }

    protected void stopListening() {
        this.entryCriteria.stopListening();
        this.reactivators.stopListening();
        this.exitCriteria.stopListening();
    }

    public PlanItemTransitionPublisher getPublisher() {
        return this.transitionPublisher;
    }

    public void connectOnPart(PlanItemOnPart planItemOnPart) {
        this.getPublisher().connectOnPart(planItemOnPart);
    }

    public void releaseOnPart(PlanItemOnPart planItemOnPart) {
        this.getPublisher().releaseOnPart(planItemOnPart);
    }

    void repeat(String string) {
        this.addDebugInfo(() -> this + ": initiating repeat logic because " + string, new Object[0]);
        if (!this.stageAllowsActivity()) {
            this.addDebugInfo(() -> this + ": not repeating because stage is not active, but " + this.getStage().getState(), new Object[0]);
            return;
        }
        this.addDebugInfo(() -> this + ": evaluating RepetitionRule from within repeat()", new Object[0]);
        this.evaluateRepetitionRule(false);
        if (this.repeats()) {
            if (this.getItemDefinition().isDiscretionary()) {
                this.addDebugInfo(() -> this + ": not repeating because item is discretionary and needs to be planned explicitly", new Object[0]);
            } else {
                PlanItem<?> planItem = this.stage.repeatChild(this);
                Transition transition = this.getEntryTransition();
                this.addDebugInfo(() -> this + ": triggering transition " + planItem + "." + transition + " within repeat (because " + string + ")", new Object[0]);
                planItem.makeTransition(transition);
            }
        } else {
            this.addDebugInfo(() -> this + ": not or no longer repeating", new Object[0]);
        }
    }

    protected boolean prepareTransition(Transition transition) {
        if (this.nextTransition != Transition.None) {
            this.addDebugInfo(() -> this + ": trying to prepareTransition " + transition + " on " + this + ", but we are already transitioning " + this.nextTransition, new Object[0]);
            return false;
        }
        this.nextTransition = transition;
        this.addDebugInfo(() -> this + ": acquired lock for transition " + transition + " on " + this, new Object[0]);
        return true;
    }

    private boolean hasLock(Transition transition) {
        if (this.nextTransition != Transition.None && !this.nextTransition.equals((Object)transition)) {
            return false;
        }
        this.nextTransition = Transition.None;
        return true;
    }

    public boolean makeTransition(Transition transition) {
        if (!this.hasLock(transition)) {
            this.addDebugInfo(() -> "StateMachine-" + this + ": cannot acquire lock for transition " + transition + " since currently transitioning " + this.nextTransition, new Object[0]);
            return false;
        }
        PlanItemTransitioned planItemTransitioned = this.stateMachine.transition(this, transition);
        if (planItemTransitioned != null) {
            this.addDebugInfo(() -> "StateMachine-" + this + ": allows transition: " + planItemTransitioned.getHistoryState() + "." + planItemTransitioned.getTransition().getValue() + "() ===> " + planItemTransitioned.getCurrentState(), new Object[0]);
            this.addEvent(planItemTransitioned);
            return true;
        }
        this.addDebugInfo(() -> "StateMachine-" + this + ": transition " + transition + " has no effect, current state remains " + this.getState(), new Object[0]);
        return false;
    }

    private void setItemDefinition(ItemDefinition itemDefinition) {
        this.previousItemDefinition = this.itemDefinition;
        this.itemDefinition = itemDefinition;
    }

    public ItemDefinition getPreviousItemDefinition() {
        return this.previousItemDefinition;
    }

    public ItemDefinition getItemDefinition() {
        return this.itemDefinition;
    }

    public State getState() {
        return this.state;
    }

    public State getHistoryState() {
        return this.historyState;
    }

    public Transition getLastTransition() {
        return this.lastTransition;
    }

    public boolean repeats() {
        return this.repetitionRuleOutcome;
    }

    public PlanItemEntry getEntryCriteria() {
        return this.entryCriteria;
    }

    public PlanItemExit getExitCriteria() {
        return this.exitCriteria;
    }

    void evaluateRepetitionRule(boolean bl) {
        boolean bl2 = this.getItemDefinition().getPlanItemControl().getRepetitionRule().evaluate(this);
        if (bl || bl2 != this.repetitionRuleOutcome) {
            this.addEvent(new RepetitionRuleEvaluated(this, bl2));
        } else {
            this.addDebugInfo(() -> "New evaluation of repetition rule still gives " + bl2, new Object[0]);
        }
    }

    void evaluateRequiredRule() {
        boolean bl = this.getItemDefinition().getPlanItemControl().getRequiredRule().evaluate(this);
        this.addEvent(new RequiredRuleEvaluated(this, bl));
    }

    Transition evaluateManualActivationRule() {
        boolean bl = this.getItemDefinition().getPlanItemControl().getManualActivationRule().evaluate(this);
        return bl ? Transition.Enable : Transition.Start;
    }

    public boolean isRequired() {
        return this.requiredRuleOutcome;
    }

    public void updateState(RepetitionRuleEvaluated repetitionRuleEvaluated) {
        this.repetitionRuleOutcome = repetitionRuleEvaluated.isRepeating();
    }

    public void updateState(RequiredRuleEvaluated requiredRuleEvaluated) {
        this.requiredRuleOutcome = requiredRuleEvaluated.isRequired();
    }

    public void publishTransition(PlanItemTransitioned planItemTransitioned) {
        this.getPublisher().addEvent(planItemTransitioned);
    }

    @Override
    public void updateStandardEvent(PlanItemTransitioned planItemTransitioned) {
        this.state = planItemTransitioned.getCurrentState();
        this.historyState = planItemTransitioned.getHistoryState();
        this.lastTransition = planItemTransitioned.getTransition();
    }

    public void runStateMachineAction(PlanItemTransitioned planItemTransitioned) {
        Transition transition = planItemTransitioned.getTransition();
        State state = planItemTransitioned.getCurrentState();
        State state2 = planItemTransitioned.getHistoryState();
        this.addDebugInfo(() -> this + ": handling transition '" + transition.getValue() + "' from " + state2 + " to " + state, new Object[0]);
        StateMachine.Action action = this.stateMachine.getAction(state);
        this.addDebugInfo(() -> "StateMachine-" + this + ": running action for state '" + state + "'", new Object[0]);
        action.execute(this, transition);
    }

    public void informConnectedEntryCriteria(PlanItemTransitioned planItemTransitioned) {
        this.getPublisher().informEntryCriteria(planItemTransitioned);
    }

    public void informParent(PlanItemTransitioned planItemTransitioned) {
        Stage<?> stage = this.getStage();
        if (stage != null) {
            this.addDebugInfo(() -> this + ": informing parent about our transition '" + planItemTransitioned.getTransition().getValue() + "' from " + planItemTransitioned.getHistoryState() + " to " + planItemTransitioned.getCurrentState(), new Object[0]);
            stage.childTransitioned(this, planItemTransitioned);
        }
    }

    public void informConnectedExitCriteria(PlanItemTransitioned planItemTransitioned) {
        this.getPublisher().informExitCriteria(planItemTransitioned);
        this.addDebugInfo(() -> this + ": completed handling transition '" + planItemTransitioned.getTransition().getValue() + "' from " + planItemTransitioned.getHistoryState() + " to " + planItemTransitioned.getCurrentState(), new Object[0]);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.getItemDefinition().getName();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public int getIndex() {
        return this.index;
    }

    public int getRepeatIndex() {
        return this.getRepeatIndex("");
    }

    protected int getRepeatIndex(String string) {
        if (this.getItemDefinition().getPlanItemControl().getRepetitionRule().isDefault()) {
            if (this.getStage() != null) {
                return this.getStage().getRepeatIndex(this.getName() + "." + string);
            }
            this.addDebugInfo(() -> "There is no repeating plan item in tree '" + this.getName() + "." + string + "', returning index 0", new Object[0]);
            return 0;
        }
        this.addDebugInfo(() -> "Found repeat index '" + this.getName() + "[" + this.index + "]" + (String)(string.isBlank() ? "" : "." + string) + "'", new Object[0]);
        return this.index;
    }

    public PlanItemType getType() {
        return ((PlanItemDefinitionDefinition)this.getDefinition()).getItemType();
    }

    public Stage<?> getStage() {
        return this.stage;
    }

    final String toDescription() {
        return this.getType() + "[" + this.getName() + "|index=" + this.getIndex() + "|state=" + this.getState() + "|required=" + this.isRequired() + "|repeating=" + this.repeats() + "]";
    }

    @Override
    public String toString() {
        return this.getType() + "[" + this.getName() + "." + this.index + "]";
    }

    protected void dumpImplementationToXML(Element element) {
    }

    protected void dumpMemoryStateToXML(Element element) {
        Element element2 = element.getOwnerDocument().createElement(this.getType().toString());
        element.appendChild(element2);
        element2.setAttribute("_id", this.getId());
        element2.setAttribute("name", this.getName());
        if (this.repeats() || this.index > 0) {
            element2.setAttribute("index", "" + this.index);
        }
        if (!(this instanceof CasePlan) && !this.getItemDefinition().getPlanItemControl().getRepetitionRule().isDefault()) {
            element2.setAttribute("repeat", "" + this.repeats());
        }
        element2.setAttribute("state", "" + this.getState());
        element2.setAttribute("transition", "" + this.getLastTransition());
        element2.setAttribute("history", "" + this.getHistoryState());
        this.dumpImplementationToXML(element2);
        this.entryCriteria.dumpMemoryStateToXML(element2);
        this.exitCriteria.dumpMemoryStateToXML(element2);
    }

    public boolean stageAllowsActivity() {
        return this.getStage() == null || this.getStage().getState().allowsActivity();
    }

    public void validateTransition(Transition transition) {
        if (!this.stageAllowsActivity()) {
            throw new InvalidCommandException("Cannot perform action '" + transition + "' on '" + this.getName() + "', since the surrounding stage is not active");
        }
    }

    protected void createInstance() {
        this.evaluateRepetitionRule(true);
        this.evaluateRequiredRule();
        this.getEntryCriteria().beginLifeCycle();
    }

    protected void completeInstance() {
    }

    protected void terminateInstance() {
    }

    protected void startInstance() {
    }

    protected void suspendInstance() {
    }

    protected void resumeInstance() {
    }

    protected void reactivateInstance() {
    }

    protected void failInstance() {
    }

    protected void retrieveDiscretionaryItems(Collection<DiscretionaryItem> collection) {
    }

    protected boolean hasDiscretionaryItems() {
        return false;
    }

    protected abstract Transition getEntryTransition();

    final Transition getExitTransition() {
        return this.stateMachine.exitTransition;
    }

    final Transition getTerminationTransition() {
        return this.stateMachine.terminationTransition;
    }

    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
    }

    protected void migrateItemDefinition(ItemDefinition itemDefinition, T t, boolean bl) {
        this.addDebugInfo(() -> "=== Migrating " + this + " to a new definition", new Object[0]);
        super.migrateDefinition(t, bl);
        this.setItemDefinition(itemDefinition);
        if (!bl && this.getState().isCreated()) {
            if (this.hasNewNameOrId()) {
                this.addEvent(new PlanItemMigrated(this));
            }
            if ((!this.getState().isSemiTerminal() || this.getState() == State.Failed) && this.hasNewRequiredRule()) {
                this.evaluateRequiredRule();
            }
        }
        this.getEntryCriteria().migrateCriteria(itemDefinition, bl);
        this.getExitCriteria().migrateCriteria(itemDefinition, bl);
        this.addDebugInfo(() -> "=== Completed migration of " + this + "\n", new Object[0]);
    }

    private boolean hasNewNameOrId() {
        String string = this.getPreviousItemDefinition().getName();
        String string2 = this.getPreviousItemDefinition().getId();
        String string3 = this.getItemDefinition().getName();
        String string4 = this.getItemDefinition().getId();
        return !string.equals(string3) || !string2.equals(string4);
    }

    private boolean hasNewRequiredRule() {
        ConstraintDefinition constraintDefinition = this.getPreviousItemDefinition().getPlanItemControl().getRequiredRule();
        return this.getItemDefinition().getPlanItemControl().getRequiredRule().differs(constraintDefinition);
    }

    @Override
    protected boolean hasNewDefinition() {
        return this.previousItemDefinition != null && this.itemDefinition.differs(this.previousItemDefinition);
    }

    protected void lostDefinition() {
        this.addDebugInfo(() -> "Dropping plan item " + this.getPath() + " upon case migration, as a new definition is not found for the plan item.", new Object[0]);
        this.addEvent(new PlanItemDropped(this));
    }

    public void updateState(PlanItemDropped planItemDropped) {
        this.stopListening();
        this.getStage().removeDroppedPlanItem(this);
        this.getCaseInstance().removeDroppedPlanItem(this);
    }
}

