/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.sentry.ReactivateCriterionDefinition;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.sentry.CriteriaListener;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.ReactivatingCriterion;
import org.w3c.dom.Element;

public class PlanItemReactivator
extends CriteriaListener<ReactivateCriterionDefinition, ReactivatingCriterion> {
    PlanItemReactivator(PlanItem<?> planItem) {
        super(planItem, planItem.getItemDefinition().getReactivatingCriteria());
    }

    @Override
    protected ReactivatingCriterion createCriterion(ReactivateCriterionDefinition reactivateCriterionDefinition) {
        return new ReactivatingCriterion(this, reactivateCriterionDefinition);
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    @Override
    public void satisfy(Criterion<?> criterion) {
        if (this.item.getState().isFailed()) {
            this.item.addDebugInfo(() -> this.item + " is in Failed state, and " + criterion + " is satisfied and will trigger " + Transition.Reactivate, new Object[0]);
            this.item.makeTransition(Transition.Reactivate);
        } else if (this.item.getState().isDone()) {
            this.item.addDebugInfo(() -> this.item + " is in state " + this.item.getState() + " so reactivation criteria can be released", new Object[0]);
            this.stopListening();
        }
    }

    public void dumpMemoryStateToXML(Element element) {
        if (this.criteria.isEmpty()) {
            return;
        }
        element.appendChild(element.getOwnerDocument().createComment(" Reactivation criteria "));
        for (Criterion criterion : this.criteria) {
            criterion.dumpMemoryStateToXML(element, true);
        }
    }

    @Override
    protected void migrateCriteria(ItemDefinition itemDefinition, boolean bl) {
        this.migrateCriteria(itemDefinition.getReactivatingCriteria(), bl);
    }
}

