/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.PlanFragmentDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.PlanningTableDefinition;
import org.cafienne.cmmn.definition.StageDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.StateMachine;
import org.cafienne.cmmn.instance.TaskStage;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.util.Guid;
import org.w3c.dom.Element;

public class Stage<T extends StageDefinition>
extends TaskStage<T> {
    private final Collection<PlanItem<?>> planItems = new ArrayList();
    private static final boolean usePureCHMMFaultHandling = Cafienne.config().engine().interpreter().usePureCMMNFaultHandling();

    public Stage(String string, int n, ItemDefinition itemDefinition, T t, Stage<?> stage, Case case_) {
        this(string, n, itemDefinition, t, stage, case_, StateMachine.TaskStage);
    }

    protected Stage(String string, int n, ItemDefinition itemDefinition, T t, Stage<?> stage, Case case_, StateMachine stateMachine) {
        super(string, n, itemDefinition, t, case_, stage, stateMachine);
    }

    void register(PlanItem<?> planItem3) {
        if (this.getCaseInstance().recoveryRunning() && planItem3.getIndex() > 0) {
            this.planItems.stream().filter(planItem2 -> ((PlanItemDefinitionDefinition)planItem2.getDefinition()).equals(planItem3.getDefinition()) && planItem2.getIndex() + 1 == planItem3.getIndex()).forEach(planItem -> planItem.getEntryCriteria().stopListening());
        }
        this.planItems.add(planItem3);
    }

    public Collection<PlanItem<?>> getPlanItems() {
        return this.planItems;
    }

    void planChild(DiscretionaryItem discretionaryItem, String string) {
        int n = Long.valueOf(this.planItems.stream().filter(planItem -> planItem.getItemDefinition().equals(discretionaryItem.getDefinition())).count()).intValue();
        this.addChild((ItemDefinition)discretionaryItem.getDefinition(), string, n, true);
    }

    PlanItem<?> repeatChild(PlanItem<?> planItem) {
        String string = new Guid().toString();
        ItemDefinition itemDefinition = planItem.getItemDefinition();
        int n = (int)this.getPlanItems().stream().map(PlanItem::getItemDefinition).filter(itemDefinition2 -> itemDefinition2.equals(itemDefinition)).count();
        this.addDebugInfo(() -> planItem + ": creating repeat item with index " + n + " and id " + string, new Object[0]);
        return this.addChild(itemDefinition, string, n, true);
    }

    private PlanItem<?> addChild(ItemDefinition itemDefinition, String string, int n, boolean bl) {
        if (this.getCaseInstance().recoveryRunning()) {
            return null;
        }
        PlanItemCreated planItemCreated = this.addEvent(new PlanItemCreated(this, itemDefinition, string, n));
        if (bl && this.getState().allowsActivity()) {
            planItemCreated.getCreatedPlanItem().create();
        }
        return planItemCreated.getCreatedPlanItem();
    }

    private void instantiateChild(PlanItemDefinition planItemDefinition) {
        this.addChild(planItemDefinition, new Guid().toString(), 0, false);
    }

    private void invokeCreateOnNullItems(String string) {
        List<PlanItem> list = this.planItems.stream().filter(planItem -> planItem.getState().isNull()).collect(Collectors.toList());
        if (!list.isEmpty()) {
            this.addDebugInfo(() -> "Stage[" + this.getName() + "] / " + string + ": invoking transition 'create' on " + list.size() + " items:", new Object[0]);
            list.forEach(planItem -> this.addDebugInfo(() -> " - " + planItem, new Object[0]));
        }
        list.forEach(PlanItem::create);
    }

    private boolean hasNullItems() {
        return this.planItems.stream().anyMatch(planItem -> planItem.getState().isNull());
    }

    @Override
    protected void startInstance() {
        if (this.hasNullItems()) {
            this.invokeCreateOnNullItems("creating planned discretionary items");
        }
        ((StageDefinition)this.getDefinition()).getPlanItems().forEach(this::instantiateChild);
        this.invokeCreateOnNullItems("creating default items");
        if (this.getPlanItems().isEmpty()) {
            this.tryCompletion();
        }
    }

    @Override
    protected void suspendInstance() {
        this.propagateTransition(Transition.ParentSuspend);
    }

    @Override
    protected void resumeInstance() {
        this.propagateTransition(Transition.ParentResume);
        this.invokeCreateOnNullItems("resuming stage");
    }

    @Override
    protected void reactivateInstance() {
        super.reactivateInstance();
        this.propagateTransition(Transition.Reactivate);
        this.invokeCreateOnNullItems("reactivating stage");
    }

    @Override
    protected void terminateInstance() {
        this.disconnectChildren(true);
    }

    @Override
    protected void completeInstance() {
        this.disconnectChildren(false);
    }

    protected void childTransitioned(PlanItem<?> planItem, PlanItemTransitioned planItemTransitioned) {
        if (usePureCHMMFaultHandling) {
            if (planItem.getState().isSemiTerminal()) {
                if (this.getState().isSemiTerminal()) {
                    this.addDebugInfo(() -> "---- " + this + " is in state " + this.getState() + ", hence skipping completion check for event " + planItemTransitioned, new Object[0]);
                } else {
                    this.addDebugInfo(() -> "*** " + this + ": trying to complete stage because of " + planItemTransitioned, new Object[0]);
                    this.tryCompletion();
                }
            }
        } else if (planItem.getHistoryState().isFailed()) {
            if (this.getState().isFailed()) {
                Predicate<PlanItem> predicate = planItem2 -> planItem2 != planItem && planItem2.getState().isFailed();
                if (this.getPlanItems().stream().noneMatch(predicate)) {
                    this.addDebugInfo(() -> "Reactivating stage " + this.getName() + " as we no longer have children in Fault state", new Object[0]);
                    this.makeTransition(Transition.Reactivate);
                    if (planItem.getHistoryState().isFailed()) {
                        this.tryCompletion();
                    }
                } else {
                    this.addDebugInfo(() -> {
                        String string = this.getPlanItems().stream().filter(predicate).map(planItem -> "\n*   - " + planItem.toDescription()).collect(Collectors.toList()).toString();
                        return "Cannot reactivate stage " + this.getName() + " because " + this.getPlanItems().stream().filter(planItem2 -> planItem2.getState().isFailed() && planItem2 != planItem).count() + " plan items are still in Fault state:" + string;
                    }, new Object[0]);
                }
            } else {
                this.addDebugInfo(() -> "No need to reactivate stage " + this.getName() + " upon " + planItem.getName() + "." + planItemTransitioned.getTransition() + " as the stage is in state " + this.getState(), new Object[0]);
            }
        } else if (planItemTransitioned.getTransition().isFault()) {
            if (this.getState().isFailed()) {
                this.addDebugInfo(() -> "No need to trigger failure in stage " + this.getName() + " as the stage is already in Fault state", new Object[0]);
            } else {
                this.addDebugInfo(() -> "*** " + this + ": triggering stage failure because " + planItem.getName() + " ran into failure", new Object[0]);
                this.makeTransition(Transition.Fault);
            }
        } else if (planItem.getState().isSemiTerminal()) {
            if (this.getState().isSemiTerminal()) {
                this.addDebugInfo(() -> "---- " + this + " is in state " + this.getState() + ", hence skipping completion check for event " + planItemTransitioned, new Object[0]);
            } else {
                this.addDebugInfo(() -> "*** " + this + ": trying to complete stage because of " + planItemTransitioned, new Object[0]);
                this.tryCompletion();
            }
        }
    }

    void tryCompletion() {
        if (this.isCompletionAllowed(false)) {
            this.addDebugInfo(() -> "*** " + this + ": triggering stage completion", new Object[0]);
            this.makeTransition(Transition.Complete);
        }
    }

    private boolean isCompletionAllowed(boolean bl) {
        this.addDebugInfo(() -> {
            String string = this.getPlanItems().stream().map(planItem -> "\n*   - " + planItem.toDescription()).collect(Collectors.toList()).toString();
            return "*   checking " + this.planItems.size() + " plan items for completion:" + string;
        }, new Object[0]);
        for (PlanItem<?> planItem : this.planItems) {
            if (planItem.getState().isActive()) {
                this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because '" + planItem.toDescription() + "' is still Active", new Object[0]);
                return false;
            }
            if (planItem.getState().isSemiTerminal()) continue;
            if (((StageDefinition)this.getDefinition()).autoCompletes() || bl) {
                if (!planItem.isRequired()) continue;
                this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because " + planItem.toDescription() + " is required and has state " + planItem.getState(), new Object[0]);
                return false;
            }
            this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because " + planItem.toDescription() + " has state " + planItem.getState(), new Object[0]);
            return false;
        }
        if (!((StageDefinition)this.getDefinition()).autoCompletes() && !bl && this.hasDiscretionaryItems()) {
            this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because there are still discretionary items", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void validateTransition(Transition transition) {
        super.validateTransition(transition);
        if (transition == Transition.Complete && !this.isCompletionAllowed(true)) {
            throw new InvalidCommandException("Cannot complete the stage as there are active items remaining");
        }
    }

    @Override
    protected boolean hasDiscretionaryItems() {
        PlanningTableDefinition planningTableDefinition = ((StageDefinition)this.getDefinition()).getPlanningTable();
        if (planningTableDefinition != null && planningTableDefinition.hasItems(this)) {
            return true;
        }
        for (PlanItem<?> planItem : this.getPlanItems()) {
            if (!planItem.hasDiscretionaryItems()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void retrieveDiscretionaryItems(Collection<DiscretionaryItem> collection) {
        PlanningTableDefinition planningTableDefinition = ((StageDefinition)this.getDefinition()).getPlanningTable();
        if (planningTableDefinition != null) {
            this.addDebugInfo(() -> "Iterating planning table items in " + this, new Object[0]);
            planningTableDefinition.evaluate(this, collection);
        }
        this.getPlanItems().forEach(planItem -> planItem.retrieveDiscretionaryItems(collection));
    }

    private void disconnectChildren(boolean bl) {
        for (PlanItem<?> planItem : this.planItems) {
            if (bl) {
                planItem.makeTransition(planItem.getTerminationTransition());
            }
            planItem.stopListening();
        }
    }

    private void propagateTransition(Transition transition) {
        for (PlanItem<?> planItem : this.planItems) {
            planItem.makeTransition(transition);
        }
    }

    @Override
    protected void dumpImplementationToXML(Element element) {
        super.dumpImplementationToXML(element);
        for (PlanItem<?> planItem : this.planItems) {
            planItem.dumpMemoryStateToXML(element);
        }
        if (((StageDefinition)this.getDefinition()).getPlanningTable() != null) {
            element.appendChild(element.getOwnerDocument().createComment(" Planning table "));
            ((StageDefinition)this.getDefinition()).getPlanningTable().dumpMemoryStateToXML(element, this);
        }
    }

    public boolean contains(PlanItem<?> planItem) {
        if (planItem == null) {
            return false;
        }
        Stage<?> stage = planItem.getStage();
        if (stage == null) {
            return false;
        }
        if (stage == this) {
            return true;
        }
        return this.contains(stage);
    }

    @Override
    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
        this.planItems.forEach(planItem -> planItem.updateState(caseAppliedPlatformUpdate));
    }

    @Override
    public void migrateItemDefinition(ItemDefinition itemDefinition, T t, boolean bl) {
        super.migrateItemDefinition(itemDefinition, t, bl);
        new ArrayList(this.planItems).forEach((Consumer<PlanItem<?>>)((Consumer<PlanItem>)planItem -> this.migrateChild((PlanItem<?>)planItem, bl)));
        if (bl) {
            return;
        }
        if (this.getState().isAlive()) {
            ((PlanFragmentDefinition)t).getPlanItems().stream().filter(this::doesNotHaveChild).forEach(this::instantiateChild);
            this.invokeCreateOnNullItems("migrating stage definition");
        }
    }

    private void migrateChild(PlanItem<?> planItem, boolean bl) {
        String string = planItem.getItemDefinition().getId();
        String string2 = planItem.getItemDefinition().getName();
        CMMNElementDefinition cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getPlanItem(string);
        if (cMMNElementDefinition == null && (cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getPlanItem(string2)) == null && (cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getDiscretionaryItem(string)) == null) {
            cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getDiscretionaryItem(string2);
        }
        if (cMMNElementDefinition != null) {
            this.migrateChild(planItem, (ItemDefinition)((Object)cMMNElementDefinition), bl);
        } else {
            this.dropChild(planItem);
        }
    }

    private boolean doesNotHaveChild(PlanItemDefinition planItemDefinition) {
        boolean bl = this.getPlanItems().stream().noneMatch(planItem -> planItem.getItemDefinition().getId().equals(planItemDefinition.getId()) || planItem.getName().equals(planItemDefinition.getName()));
        if (bl) {
            this.addDebugInfo(() -> this + ": migration found a new child definition " + planItemDefinition.getName() + " of type " + planItemDefinition.getType(), new Object[0]);
        }
        return bl;
    }

    private void dropChild(PlanItem<?> planItem) {
        if (this.getCaseInstance().recoveryRunning()) {
            return;
        }
        planItem.lostDefinition();
    }

    @Override
    protected void lostDefinition() {
        new ArrayList(this.planItems).forEach((Consumer<PlanItem<?>>)((Consumer<PlanItem>)PlanItem::lostDefinition));
        super.lostDefinition();
    }

    private void migrateChild(PlanItem planItem, ItemDefinition itemDefinition, boolean bl) {
        this.addDebugInfo(() -> this + ": migrating child " + planItem + " to a new definition", new Object[0]);
        Object t = planItem.getDefinition();
        PlanItemDefinitionDefinition planItemDefinitionDefinition = itemDefinition.getPlanItemDefinition();
        if (t.getClass().isAssignableFrom(planItemDefinitionDefinition.getClass())) {
            planItem.migrateItemDefinition(itemDefinition, planItemDefinitionDefinition, bl);
        } else {
            this.addDebugInfo(() -> "Not possible to migrate from " + t.getType() + " to " + planItemDefinitionDefinition.getType(), new Object[0]);
        }
    }

    void removeDroppedPlanItem(PlanItem<?> planItem) {
        this.planItems.remove(planItem);
    }
}

