/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

public enum State {
    Null,
    Active,
    Available,
    Closed,
    Completed,
    Disabled,
    Discarded,
    Enabled,
    Failed,
    Suspended,
    Terminated;


    public boolean isSemiTerminal() {
        return this == Closed || this == Completed || this == Disabled || this == Failed || this == Terminated;
    }

    public boolean isNull() {
        return this == Null;
    }

    public boolean isActive() {
        return this == Active;
    }

    public boolean isAvailable() {
        return this == Available;
    }

    public boolean isClosed() {
        return this == Closed;
    }

    public boolean isCompleted() {
        return this == Completed;
    }

    public boolean isDisabled() {
        return this == Disabled;
    }

    public boolean isDiscarded() {
        return this == Discarded;
    }

    public boolean isEnabled() {
        return this == Enabled;
    }

    public boolean isFailed() {
        return this == Failed;
    }

    public boolean isSuspended() {
        return this == Suspended;
    }

    public boolean isTerminated() {
        return this == Terminated;
    }

    public boolean isCreated() {
        return !this.isNull();
    }

    public boolean isInitiated() {
        return !this.isNull() && !this.isAvailable();
    }

    public boolean isDone() {
        return this.isCompleted() || this.isTerminated();
    }

    public boolean allowsActivity() {
        return this.isActive() || this.isFailed();
    }

    public boolean isAlive() {
        return this.isActive() || this.isSuspended() || this.isFailed() || this.isEnabled() || this.isDisabled();
    }
}

