/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.casefile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.TransitionDeniedException;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.casefile.EmptyCaseFileItem;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CaseFileItemArray
extends CaseFileItem
implements List<CaseFileItem> {
    private static final Logger logger = LoggerFactory.getLogger(CaseFileItemArray.class);
    private final List<CaseFileItem> actualArrayItems = new ArrayList<CaseFileItem>();
    private final ValueList actualValueOfCaseFileItemArray = new ValueList(new Object[0]);
    private CaseFileItem current;

    public CaseFileItemArray(Case case_, CaseFileItemDefinition caseFileItemDefinition, CaseFileItemCollection<?> caseFileItemCollection) {
        super(caseFileItemDefinition, case_, caseFileItemCollection);
        this.actualValueOfCaseFileItemArray.setOwner(this);
    }

    @Override
    public CaseFileItem getArrayElement(int n) {
        if (n < 0 || n >= this.actualArrayItems.size()) {
            if (this.getCaseInstance().recoveryRunning()) {
                if (n == this.actualArrayItems.size()) {
                    this.current = this.getNextItem();
                    return this.current;
                }
                if (n > this.actualArrayItems.size()) {
                    String string = "Encountering an strange situation during recovery. Need to recover case file item " + this.getPath() + " with index " + n + ", but the current array only holds " + this.actualArrayItems.size() + " items, so we must have missed few recovery events. Recovery continues with an empty CaseFileItem, holding illegal values";
                    logger.error(string);
                }
            }
            return new EmptyCaseFileItem((CaseFileItem)this, "Index " + n + " is out of bounds in CaseFileItem " + this.getPath());
        }
        return this.actualArrayItems.get(n);
    }

    @Override
    public Value<?> getValue() {
        return this.actualValueOfCaseFileItemArray;
    }

    @Override
    protected void itemChanged(CaseFileItem caseFileItem) {
        this.current = caseFileItem;
        Value<?> value = caseFileItem.getValue();
        int n = caseFileItem.getIndex();
        if (n < this.actualValueOfCaseFileItemArray.size()) {
            this.actualValueOfCaseFileItemArray.set(n, value);
        } else if (n == this.actualValueOfCaseFileItemArray.size()) {
            this.actualValueOfCaseFileItemArray.add(value);
        } else {
            throw new CaseFileError("We're not letting you in, number " + n + ", because we only have " + this.actualValueOfCaseFileItemArray.size() + " items, and it seems you're skipping one or more");
        }
    }

    @Override
    protected boolean allowTransition(CaseFileItemTransition caseFileItemTransition) {
        if (this.getState().isAvailable() && caseFileItemTransition == CaseFileItemTransition.Create) {
            return true;
        }
        return super.allowTransition(caseFileItemTransition);
    }

    private CaseFileItem getNextItem() {
        CaseFileItem caseFileItem = new CaseFileItem(this, this.actualArrayItems.size());
        this.actualArrayItems.add(caseFileItem);
        return caseFileItem;
    }

    @Override
    public State getState() {
        if (this.actualArrayItems.isEmpty()) {
            return State.Null;
        }
        long l = this.actualArrayItems.stream().filter(caseFileItem -> caseFileItem.getState().isAvailable()).count();
        if (l > 0L) {
            return State.Available;
        }
        return State.Discarded;
    }

    private void createNewItem(Value<?> value) {
        this.getNextItem().createContent(value);
    }

    @Override
    public void createContent(Value<?> value) {
        ValueList valueList = value.isList() ? value.asList() : new ValueList(new Object[]{value});
        for (Value<?> value2 : valueList) {
            this.createNewItem(value2);
        }
    }

    @Override
    public void updateContent(Value<?> value) {
        if (!value.isList()) {
            if (this.current != null) {
                this.addDebugInfo(() -> "Update for CaseFileItem[" + this.getPath() + "] with an object structure is executed on 'current':  (" + this.current.getPath() + ")", new Object[0]);
                this.current.updateContent(value);
            } else {
                this.createNewItem(value);
            }
            return;
        }
        ValueList valueList = value.asList();
        int n = valueList.size();
        for (int i = 0; i < n; ++i) {
            Object object = valueList.get(i);
            if (this.actualArrayItems.size() > i) {
                CaseFileItem caseFileItem = this.actualArrayItems.get(i);
                caseFileItem.updateContent((Value<?>)object);
                continue;
            }
            this.createNewItem((Value<?>)object);
        }
    }

    @Override
    public void replaceContent(Value<?> value) {
        if (!value.isList()) {
            if (this.current != null) {
                this.addDebugInfo(() -> "Replace for CaseFileItem[" + this.getPath() + "] with an object structure is executed on 'current':  (" + this.current.getPath() + ")", new Object[0]);
                this.current.replaceContent(value);
            } else {
                this.createNewItem(value);
            }
            return;
        }
        ValueList valueList = value.asList();
        int n = valueList.size();
        int n2 = this.actualArrayItems.size() - n;
        for (int i = 0; i < n; ++i) {
            Object object = valueList.get(i);
            if (this.actualArrayItems.size() > i) {
                CaseFileItem caseFileItem = this.actualArrayItems.get(i);
                caseFileItem.replaceContent((Value<?>)object);
                continue;
            }
            this.createNewItem((Value<?>)object);
        }
        while (n2-- > 0) {
            CaseFileItem caseFileItem = this.actualArrayItems.get(n + n2);
            if (this.getParent() != null) {
                this.getParent().removeChildItem(caseFileItem);
                continue;
            }
            this.getCaseInstance().getCaseFile().removeChildItem(caseFileItem);
        }
    }

    @Override
    protected void itemRemoved(int n) {
        this.actualArrayItems.remove(n);
        this.actualValueOfCaseFileItemArray.remove(n);
    }

    @Override
    public void deleteContent() {
        int n = this.actualArrayItems.size();
        while (--n >= 0) {
            this.actualArrayItems.get(n).deleteContent();
        }
    }

    @Override
    public void dumpMemoryStateToXML(Element element) {
        for (CaseFileItem caseFileItem : this.actualArrayItems) {
            caseFileItem.dumpMemoryStateToXML(element);
        }
    }

    @Override
    public CaseFileItem getItem(String string) {
        throw new TransitionDeniedException("Cannot access a property '" + string + "' of the case file item container. Have to address an individual item");
    }

    @Override
    public Iterator<CaseFileItem> iterator() {
        return this.actualArrayItems.iterator();
    }

    @Override
    public CaseFileItem getCurrent() {
        if (this.current == null) {
            this.current = this.getArrayElement(-1);
        }
        return this.current;
    }

    @Override
    public boolean add(CaseFileItem caseFileItem) {
        return this.actualArrayItems.add(caseFileItem);
    }

    @Override
    public void add(int n, CaseFileItem caseFileItem) {
        this.actualArrayItems.add(n, caseFileItem);
    }

    @Override
    public boolean addAll(Collection<? extends CaseFileItem> collection) {
        return this.actualArrayItems.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends CaseFileItem> collection) {
        return this.actualArrayItems.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.actualArrayItems.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.actualArrayItems.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.actualArrayItems.containsAll(collection);
    }

    @Override
    public CaseFileItem get(int n) {
        return this.actualArrayItems.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.actualArrayItems.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.actualArrayItems.isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.actualArrayItems.lastIndexOf(object);
    }

    @Override
    public ListIterator<CaseFileItem> listIterator() {
        return this.actualArrayItems.listIterator();
    }

    @Override
    public ListIterator<CaseFileItem> listIterator(int n) {
        return this.actualArrayItems.listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.actualArrayItems.remove(object);
    }

    @Override
    public CaseFileItem remove(int n) {
        return this.actualArrayItems.remove(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.actualArrayItems.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.actualArrayItems.retainAll(collection);
    }

    @Override
    public CaseFileItem set(int n, CaseFileItem caseFileItem) {
        return this.actualArrayItems.set(n, caseFileItem);
    }

    @Override
    public int size() {
        return this.actualArrayItems.size();
    }

    @Override
    public List<CaseFileItem> subList(int n, int n2) {
        return this.actualArrayItems.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.actualArrayItems.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.actualArrayItems.toArray(TArray);
    }
}

