/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.parameter;

import org.cafienne.cmmn.definition.parameter.BindingOperation;
import org.cafienne.cmmn.definition.parameter.BindingRefinementDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.parameter.TaskParameter;
import org.cafienne.json.StringValue;

public class TaskInputParameter
extends TaskParameter<InputParameterDefinition> {
    public TaskInputParameter(InputParameterDefinition inputParameterDefinition, Task<?> task) {
        super(inputParameterDefinition, task, null);
        if (this.hasBinding()) {
            this.bindCaseFileToTaskInputParameter();
        }
    }

    private void bindCaseFileToTaskInputParameter() {
        CaseFileItem caseFileItem = (CaseFileItem)this.getBinding().getPath().resolve(this.getCaseInstance());
        this.value = caseFileItem.getCurrent().getValue();
        BindingRefinementDefinition bindingRefinementDefinition = ((InputParameterDefinition)this.getDefinition()).getBindingRefinement();
        if (bindingRefinementDefinition != null) {
            BindingOperation bindingOperation = bindingRefinementDefinition.getRefinementOperation();
            this.addDebugInfo(() -> {
                if (bindingRefinementDefinition == null || bindingOperation == BindingOperation.None) {
                    return "Binding input parameter '" + ((InputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "] is done with default operation " + bindingOperation;
                }
                return "Binding input parameter '" + ((InputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "] is done with operation " + bindingOperation;
            }, new Object[0]);
            switch (bindingOperation) {
                case Indexed: {
                    if (caseFileItem.isArray()) {
                        this.value = caseFileItem.getArrayElement(this.task.getRepeatIndex()).getValue();
                        break;
                    }
                    this.addDebugInfo(() -> "Unexpected task input binding operation '" + bindingOperation + "' for parameter '" + ((InputParameterDefinition)this.getDefinition()).getName() + "' because case file item is not an array; passing plain value of the item", new Object[0]);
                    this.value = caseFileItem.getValue();
                    break;
                }
                case List: {
                    if (!caseFileItem.isArray()) {
                        this.addDebugInfo(() -> "Unexpected task input binding operation '" + bindingOperation + "' for parameter '" + ((InputParameterDefinition)this.getDefinition()).getName() + "' because case file item is not an array; passing plain value of the item", new Object[0]);
                    }
                    this.value = caseFileItem.getValue();
                    break;
                }
                case Current: {
                    this.value = caseFileItem.getCurrent().getValue();
                    break;
                }
                case Reference: {
                    this.value = new StringValue(caseFileItem.getPath().toString());
                    break;
                }
                case ReferenceIndexed: {
                    if (caseFileItem.isArray()) {
                        this.value = new StringValue(caseFileItem.getArrayElement(this.task.getRepeatIndex()).getPath().toString());
                        break;
                    }
                    this.addDebugInfo(() -> "Unexpected task input binding operation '" + bindingOperation + "' for parameter '" + ((InputParameterDefinition)this.getDefinition()).getName() + "' because case file item is not an array; passing plain reference of the item", new Object[0]);
                    this.value = new StringValue(caseFileItem.getPath().toString());
                }
            }
        }
    }
}

