/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.debug.DebugInfoAppender;
import org.cafienne.cmmn.instance.sentry.OnPart;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.cmmn.instance.sentry.TransitionGenerator;

public class TransitionPublisher<E extends StandardEvent<?, ?>, I extends TransitionGenerator<E>, P extends OnPart<?, E, I>> {
    protected final I item;
    private final List<E> transitions = new ArrayList();
    private final List<P> connectedEntryCriteria = new ArrayList<P>();
    private final List<P> connectedExitCriteria = new ArrayList<P>();

    public TransitionPublisher(I i) {
        this.item = i;
    }

    protected TransitionPublisher(TransitionPublisher<E, I, P> transitionPublisher) {
        transitionPublisher.releaseBootstrapEvents();
        this.item = transitionPublisher.item;
        this.connectedEntryCriteria.addAll(transitionPublisher.connectedEntryCriteria);
        this.connectedExitCriteria.addAll(transitionPublisher.connectedExitCriteria);
    }

    public void addEvent(E e) {
        this.transitions.add(0, e);
        this.updateItemState(e);
        this.informSentryNetwork(e);
    }

    protected void updateItemState(E e) {
        this.item.updateStandardEvent(e);
    }

    protected void informSentryNetwork(E e) {
        this.addDebugInfo(() -> "Informing sentry network about " + e.getTransition() + " in " + this.item.getDescription());
        this.item.getCaseInstance().getSentryNetwork().handleTransition((StandardEvent<?, ?>)e);
    }

    public void releaseBootstrapEvents() {
    }

    public void connectOnPart(P p) {
        if (((OnPart)p).getCriterion().isEntryCriterion()) {
            this.insertOnPart(p, this.connectedEntryCriteria);
        } else {
            this.insertOnPart(p, this.connectedExitCriteria);
        }
        if (((CMMNElement)p).getCaseInstance().recoveryFinished()) {
            if (((OnPart)p).getCriterion().getTarget().getIndex() == 0 && !this.transitions.isEmpty()) {
                ((OnPart)p).inform(this.item, (StandardEvent)((StandardEvent)this.transitions.get(0)));
            }
        } else {
            this.transitions.forEach(standardEvent -> p.inform(this.item, standardEvent));
        }
    }

    private void insertOnPart(P p, List<P> list) {
        int n;
        if (list.contains(p)) {
            return;
        }
        Stage<?> stage = ((OnPart)p).getCriterion().getStage();
        for (n = 0; n < list.size() && ((OnPart)list.get(n)).getCriterion().getStage().contains(stage); ++n) {
        }
        list.add(n, p);
    }

    public void informEntryCriteria(E e) {
        if (!this.connectedEntryCriteria.isEmpty()) {
            this.addDebugInfo(() -> "Informing " + this.connectedEntryCriteria.size() + " entry criteria that listen to item " + this.item.getDescription());
        }
        new ArrayList<P>(this.connectedEntryCriteria).forEach((Consumer<P>)((Consumer<OnPart>)onPart -> onPart.inform(this.item, e)));
    }

    public void informExitCriteria(E e) {
        if (!this.connectedExitCriteria.isEmpty()) {
            this.addDebugInfo(() -> "Informing " + this.connectedExitCriteria.size() + " exit criteria that listen to item " + this.item.getDescription());
        }
        new ArrayList<P>(this.connectedExitCriteria).forEach((Consumer<P>)((Consumer<OnPart>)onPart -> onPart.inform(this.item, e)));
    }

    public void releaseOnPart(P p) {
        if (((OnPart)p).getCriterion().isEntryCriterion()) {
            this.connectedEntryCriteria.remove(p);
        } else {
            this.connectedExitCriteria.remove(p);
        }
    }

    protected void addDebugInfo(DebugInfoAppender debugInfoAppender) {
        this.item.getCaseInstance().addDebugInfo(debugInfoAppender, new Object[0]);
    }
}

