/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.task.cmmn;

import org.cafienne.cmmn.actorapi.command.ReactivateCase;
import org.cafienne.cmmn.actorapi.command.StartCase;
import org.cafienne.cmmn.actorapi.command.migration.MigrateCaseDefinition;
import org.cafienne.cmmn.actorapi.command.plan.MakeCaseTransition;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.CaseTaskDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseTask
extends Task<CaseTaskDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(CaseTask.class);
    private final String subCaseId = this.getId();
    private final Case mainCase = this.getCaseInstance();

    public CaseTask(String string, int n, ItemDefinition itemDefinition, CaseTaskDefinition caseTaskDefinition, Stage<?> stage) {
        super(string, n, itemDefinition, caseTaskDefinition, stage);
    }

    @Override
    protected void startImplementation(ValueMap valueMap) {
        CaseDefinition caseDefinition = ((CaseTaskDefinition)this.getDefinition()).getImplementationDefinition();
        String string = this.mainCase.getId();
        String string2 = this.mainCase.getRootCaseId();
        CaseTeam caseTeam = this.mainCase.getCaseTeam().createSubCaseTeam(caseDefinition);
        StartCase startCase = new StartCase(this.getCaseInstance().getTenant(), this.getCaseInstance().getCurrentUser(), this.subCaseId, caseDefinition, valueMap, caseTeam, this.getCaseInstance().debugMode(), string, string2);
        this.startTaskImplementation(startCase);
    }

    @Override
    protected void suspendImplementation() {
        this.tell(Transition.Suspend);
    }

    @Override
    protected void resumeImplementation() {
        this.tell(Transition.Reactivate);
    }

    @Override
    protected void terminateImplementation() {
        if (this.getHistoryState() == State.Available) {
            this.addDebugInfo(() -> "Terminating human task '" + this.getName() + "' without it being started; no need to inform the task actor", new Object[0]);
        } else {
            this.tell(Transition.Terminate);
        }
    }

    @Override
    protected void reactivateImplementation(ValueMap valueMap) {
        CaseDefinition caseDefinition = ((CaseTaskDefinition)this.getDefinition()).getImplementationDefinition();
        String string = this.mainCase.getId();
        String string2 = this.mainCase.getRootCaseId();
        CaseTeam caseTeam = this.mainCase.getCaseTeam().createSubCaseTeam(caseDefinition);
        ReactivateCase reactivateCase = new ReactivateCase(this.getCaseInstance().getTenant(), this.getCaseInstance().getCurrentUser(), this.subCaseId, caseDefinition, valueMap, caseTeam, this.getCaseInstance().debugMode(), string, string2);
        this.reactivateTaskImplementation(reactivateCase);
    }

    private void tell(Transition transition) {
        this.tellTaskImplementation(new MakeCaseTransition(this.getCaseInstance().getCurrentUser(), this.subCaseId, transition));
    }

    @Override
    public void migrateItemDefinition(ItemDefinition itemDefinition, CaseTaskDefinition caseTaskDefinition, boolean bl) {
        super.migrateItemDefinition(itemDefinition, caseTaskDefinition, bl);
        if (bl) {
            return;
        }
        CaseDefinition caseDefinition = caseTaskDefinition.getImplementationDefinition();
        CaseTeam caseTeam = this.mainCase.getCaseTeam().createSubCaseTeam(caseDefinition);
        this.giveNewDefinition(new MigrateCaseDefinition(this.getCaseInstance().getCurrentUser(), this.getId(), caseDefinition, caseTeam));
    }

    @Override
    protected void lostDefinition() {
        this.addDebugInfo(() -> "Dropping CaseTasks through migration is not possible. Task[" + this.getPath() + "] remains in the case with current state '" + this.getState() + "'", new Object[0]);
    }
}

