/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.util.ArrayList;
import java.util.List;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.test.assertions.PlanItemAssertion;

public class PlanItemSetAssertion {
    private final List<PlanItemAssertion> planItems = new ArrayList<PlanItemAssertion>();
    private final String identifier;

    PlanItemSetAssertion(String string) {
        this.identifier = string;
    }

    void add(PlanItemAssertion planItemAssertion) {
        this.planItems.add(planItemAssertion);
    }

    public List<PlanItemAssertion> getPlanItems() {
        return this.planItems;
    }

    public PlanItemAssertion first() {
        return this.planItems.get(0);
    }

    public PlanItemSetAssertion filter(State state) {
        PlanItemSetAssertion planItemSetAssertion = new PlanItemSetAssertion(this.identifier);
        for (PlanItemAssertion planItemAssertion : this.planItems) {
            if (!planItemAssertion.getState().equals((Object)state)) continue;
            planItemSetAssertion.add(planItemAssertion);
        }
        return planItemSetAssertion;
    }

    public PlanItemSetAssertion assertStates(State ... stateArray) {
        for (State state : stateArray) {
            this.assertAtLeastOneWithState(state);
        }
        return this;
    }

    public PlanItemSetAssertion assertNoMoreRepetition() {
        this.planItems.get(this.planItems.size() - 1).assertNoRepetition();
        return this;
    }

    public PlanItemSetAssertion assertRepeats() {
        this.planItems.get(this.planItems.size() - 1).assertRepeats();
        return this;
    }

    public PlanItemSetAssertion assertAtLeastOneWithState(State state) {
        for (PlanItemAssertion planItemAssertion : this.planItems) {
            if (!planItemAssertion.getState().equals((Object)state)) continue;
            return this;
        }
        throw new AssertionError((Object)("There is no plan item with state " + state + " in the collection of plan items named " + this.identifier));
    }

    public PlanItemSetAssertion assertNotEmpty() {
        if (this.planItems.isEmpty()) {
            throw new AssertionError((Object)("There is no plan item named '" + this.identifier + "'"));
        }
        return this;
    }

    public PlanItemSetAssertion assertSize(int n) {
        if (this.planItems.size() != n) {
            throw new AssertionError((Object)("Expecting " + n + " plan items '" + this.identifier + "', but found " + this.planItems.size()));
        }
        return this;
    }
}

