/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.actorapi.response.GetDiscretionaryItemsResponse;
import org.cafienne.cmmn.test.assertions.CaseAssertion;
import org.cafienne.cmmn.test.assertions.DiscretionaryItemAssertion;
import org.cafienne.cmmn.test.assertions.ModelTestCommandAssertion;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueList;

public class PlanningTableAssertion
extends ModelTestCommandAssertion {
    private final Collection<DiscretionaryItemAssertion> discretionaries = new ArrayList<DiscretionaryItemAssertion>();
    private final GetDiscretionaryItemsResponse response;
    private ValueList items = new ValueList(new Object[0]);

    public PlanningTableAssertion(CaseAssertion caseAssertion) {
        super(caseAssertion.getTestCommand());
        this.response = (GetDiscretionaryItemsResponse)caseAssertion.getTestCommand().getActualResponse();
        this.response.toJson().withArray((Object)Fields.discretionaryItems).forEach(value -> this.discretionaries.add(new DiscretionaryItemAssertion(caseAssertion.getTestCommand(), value.asMap())));
    }

    public String toString() {
        return this.response.toString();
    }

    public void assertNoItems() {
        if (!this.discretionaries.isEmpty()) {
            throw new AssertionError((Object)("Expect no discretionary items, but found " + this.items.size()));
        }
    }

    public void assertItems() {
        if (this.discretionaries.isEmpty()) {
            throw new AssertionError((Object)"Expect discretionary items, but found none");
        }
    }

    public void assertItems(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.assertItem(string);
        }
    }

    public DiscretionaryItemAssertion assertItem(String string) {
        DiscretionaryItemAssertion discretionaryItemAssertion = this.getItem(string);
        if (discretionaryItemAssertion != null) {
            return discretionaryItemAssertion;
        }
        throw new AssertionError((Object)("A discretionary item '" + string + "' cannot be found in the planning table"));
    }

    public void assertNoItem(String string) {
        DiscretionaryItemAssertion discretionaryItemAssertion = this.getItem(string);
        if (discretionaryItemAssertion != null) {
            throw new AssertionError((Object)("A discretionary item '" + string + "' is found in the planning table, but it is not supposed to be there"));
        }
    }

    private DiscretionaryItemAssertion getItem(String string) {
        for (DiscretionaryItemAssertion discretionaryItemAssertion : this.discretionaries) {
            if (!discretionaryItemAssertion.getName().equals(string) && !discretionaryItemAssertion.getDefinitionId().equals(string)) continue;
            return discretionaryItemAssertion;
        }
        return null;
    }
}

