/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions.file;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.assertions.ModelTestCommandAssertion;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;
import org.cafienne.cmmn.test.assertions.file.CaseFileItemAssertion;
import org.cafienne.cmmn.test.filter.EventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseFileAssertion
extends ModelTestCommandAssertion {
    private static final Logger logger = LoggerFactory.getLogger(CaseFileAssertion.class);
    private final Map<Path, CaseFileItemAssertion> assertions = new HashMap<Path, CaseFileItemAssertion>();

    public CaseFileAssertion(CaseTestCommand caseTestCommand) {
        super(caseTestCommand);
        PublishedEventsAssertion<CaseFileItemTransitioned> publishedEventsAssertion = caseTestCommand.getEventListener().getEvents().filter(CaseFileItemTransitioned.class);
        publishedEventsAssertion.filter(CaseFileItemTransitioned.class).getEvents().forEach(caseFileItemTransitioned -> this.assertCaseFileItem(caseFileItemTransitioned.getPath()).addEvent((CaseFileItemTransitioned)caseFileItemTransitioned));
    }

    public CaseFileItemTransitioned awaitCaseFileEvent(Path path, EventFilter<CaseFileItemTransitioned> eventFilter, long ... lArray) {
        logger.debug("Waiting for case file event on path " + path);
        return this.testCommand.getEventListener().waitUntil("CaseFileItemTransitioned-" + path, CaseFileItemTransitioned.class, caseFileItemTransitioned -> {
            boolean bl = path.matches(caseFileItemTransitioned.getPath());
            if (bl) {
                logger.debug("Receiving case file event " + caseFileItemTransitioned);
            }
            return bl && eventFilter.matches((CaseFileItemTransitioned)caseFileItemTransitioned);
        }, lArray);
    }

    public CaseFileItemAssertion assertCaseFileItem(Path path) {
        Path path3 = this.assertions.keySet().stream().filter(path2 -> path2.matches(path)).findAny().orElse(null);
        if (path3 == null) {
            path3 = path;
        }
        CaseFileItemAssertion caseFileItemAssertion = this.assertions.getOrDefault(path3, new CaseFileItemAssertion(this, this.testCommand, path));
        this.assertions.put(path3, caseFileItemAssertion);
        return caseFileItemAssertion;
    }

    List<CaseFileItemAssertion> getArrayElements(Path path) {
        ArrayList<CaseFileItemAssertion> arrayList = new ArrayList<CaseFileItemAssertion>();
        this.assertions.entrySet().stream().filter(entry -> ((Path)entry.getKey()).isArrayElementOf(path)).forEach(entry -> arrayList.add((CaseFileItemAssertion)entry.getValue()));
        arrayList.sort(Comparator.comparing(CaseFileItemAssertion::getIndexInArray));
        return arrayList;
    }
}

