/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.cqrs;

import akka.actor.ActorSystem;
import akka.persistence.query.PersistenceQuery;
import akka.persistence.query.PersistenceQuery$;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import com.typesafe.scalalogging.LazyLogging;
import org.cafienne.infrastructure.Cafienne$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00054q\u0001C\u0005\u0011\u0002\u0007\u0005!\u0003C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0019\u0005\u0011\u0006C\u00033\u0001\u0011\r\u0011\u0006\u0003\u00054\u0001!\u0015\r\u0011\"\u00015\u0011!\u0001\u0005\u0001#b\u0001\n\u0003!\u0004\"B!\u0001\t\u0003\u0011\u0005\"B0\u0001\t\u0013\u0001'a\u0005*fC\u0012Tu.\u001e:oC2\u0004&o\u001c<jI\u0016\u0014(B\u0001\u0006\f\u0003\u0011\u0019\u0017O]:\u000b\u00051i\u0011AD5oMJ\f7\u000f\u001e:vGR,(/\u001a\u0006\u0003\u001d=\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ\u0012%D\u0001\u001c\u0015\taR$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001f?\u0005AA/\u001f9fg\u00064WMC\u0001!\u0003\r\u0019w.\\\u0005\u0003Em\u00111\u0002T1{s2{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012!\n\t\u0003)\u0019J!aJ\u000b\u0003\tUs\u0017\u000e^\u0001\u0007gf\u001cH/Z7\u0016\u0003)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003=\nA!Y6lC&\u0011\u0011\u0007\f\u0002\f\u0003\u000e$xN]*zgR,W.A\u0006bGR|'oU=ti\u0016l\u0017!E2p]\u001aLw-\u001e:fI*{WO\u001d8bYV\tQ\u0007\u0005\u00027{9\u0011qg\u000f\t\u0003qUi\u0011!\u000f\u0006\u0003uE\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q*\u0012A\u0005:fC\u0012Tu.\u001e:oC2\u001cV\r\u001e;j]\u001e\fqA[8ve:\fG\u000eF\u0001D%\u001d!e\tU*W3r3A!\u0012\u0001\u0001\u0007\naAH]3gS:,W.\u001a8u}A\u0011qIT\u0007\u0002\u0011*\u0011\u0011JS\u0001\tg\u000e\fG.\u00193tY*\u00111\nT\u0001\u0006cV,'/\u001f\u0006\u0003\u001b:\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\n\u0013\u0002\f%\u0016\fGMS8ve:\fG\u000e\u0005\u0002H#&\u0011!\u000b\u0013\u0002\u001b\u0007V\u0014(/\u001a8u!\u0016\u00148/[:uK:\u001cW-\u00133t#V,'/\u001f\t\u0003\u000fRK!!\u0016%\u0003!\u00153XM\u001c;t\u0005f$\u0016mZ)vKJL\bCA$X\u0013\tA\u0006JA\fDkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z)\u0006<\u0017+^3ssB\u0011qIW\u0005\u00037\"\u0013!$\u0012<f]R\u001c()\u001f)feNL7\u000f^3oG\u0016LE-U;fef\u0004\"aR/\n\u0005yC%!I\"veJ,g\u000e^#wK:$8OQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ)vKJL\u0018A\u00064j]\u0012\u0014V-\u00193K_V\u0014h.\u00197TKR$\u0018N\\4\u0015\u0003U\u0002")
public interface ReadJournalProvider
extends LazyLogging {
    public ActorSystem system();

    public static /* synthetic */ ActorSystem actorSystem$(ReadJournalProvider $this) {
        return $this.actorSystem();
    }

    default public ActorSystem actorSystem() {
        return this.system();
    }

    public static /* synthetic */ String configuredJournal$(ReadJournalProvider $this) {
        return $this.configuredJournal();
    }

    default public String configuredJournal() {
        return this.system().settings().config().getString("akka.persistence.journal.plugin");
    }

    public static /* synthetic */ String readJournalSetting$(ReadJournalProvider $this) {
        return $this.readJournalSetting();
    }

    default public String readJournalSetting() {
        return this.findReadJournalSetting();
    }

    public static /* synthetic */ CurrentPersistenceIdsQuery journal$(ReadJournalProvider $this) {
        return $this.journal();
    }

    default public CurrentPersistenceIdsQuery journal() {
        return (CurrentPersistenceIdsQuery)((PersistenceQuery)PersistenceQuery$.MODULE$.apply(this.system())).readJournalFor(this.readJournalSetting());
    }

    private String findReadJournalSetting() {
        BoxedUnit boxedUnit;
        String explicitReadJournal = Cafienne$.MODULE$.config().readJournal();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(explicitReadJournal))) {
            return explicitReadJournal;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Missing conf 'cafienne.read-journal'. Trying to determine read journal settings by guessing based on the name of the journal plugin \"" + this.configuredJournal() + "\"");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.configuredJournal().contains("jdbc")) {
            return "jdbc-read-journal";
        }
        if (this.configuredJournal().contains("cassandra")) {
            return "akka.persistence.cassandra.query";
        }
        if (this.configuredJournal().contains("level")) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Found Level DB based configurations. This has proven to be unreliable. Do not use it in Production systems.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return "akka.persistence.query.journal.leveldb";
        }
        if (this.configuredJournal().contains("memory")) {
            return "inmemory-read-journal";
        }
        throw new RuntimeException("Cannot find read journal for " + this.configuredJournal() + ", please use Cassandra or JDBC read journal settings");
    }

    public static void $init$(ReadJournalProvider $this) {
    }
}

