/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.actorapi.command.ProcessCommand;
import org.cafienne.processtask.actorapi.event.ProcessDefinitionMigrated;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.instance.ProcessTaskActor;

@Manifest
public class MigrateProcessDefinition
extends ProcessCommand {
    private final ProcessDefinition newDefinition;

    public MigrateProcessDefinition(UserIdentity userIdentity, String string, ProcessDefinition processDefinition) {
        super(userIdentity, string);
        this.newDefinition = processDefinition;
    }

    public MigrateProcessDefinition(ValueMap valueMap) {
        super(valueMap);
        this.newDefinition = valueMap.readDefinition((Object)Fields.definition, ProcessDefinition.class);
    }

    public ProcessDefinition getNewDefinition() {
        return this.newDefinition;
    }

    @Override
    public String toString() {
        return "Migrate Case Definition '" + this.newDefinition.getName() + "'";
    }

    @Override
    protected void process(ProcessTaskActor processTaskActor, SubProcess<?> subProcess) {
        if (processTaskActor.getDefinition().sameProcessDefinition(this.newDefinition)) {
            processTaskActor.addDebugInfo(() -> "No need to migrate definition of process task " + processTaskActor.getId() + " (proposed definition already in use)", new Object[0]);
        } else if (!processTaskActor.getDefinition().getImplementation().sameType(this.newDefinition.getImplementation())) {
            processTaskActor.addDebugInfo(() -> "Migration of process task implementation to a different type is not supported", new Object[0]);
        } else {
            processTaskActor.addEvent(new ProcessDefinitionMigrated(processTaskActor, this));
        }
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelCommand(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.definition, this.newDefinition);
    }
}

