/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation;

import java.util.Collection;
import java.util.Map;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.definition.SubProcessOutputMappingDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubProcess<T extends SubProcessDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(SubProcess.class);
    protected final ProcessTaskActor processTaskActor;
    private T definition;
    private final ValueMap rawOutputParameters = new ValueMap();
    private final ValueMap processOutputParameters = new ValueMap();

    protected SubProcess(ProcessTaskActor processTaskActor, T t) {
        this.processTaskActor = processTaskActor;
        this.definition = t;
    }

    public T getDefinition() {
        return this.definition;
    }

    public void setDefinition(T t) {
        this.definition = t;
    }

    protected final void raiseComplete() {
        this.transformRawParametersToProcessOutputParameters(((SubProcessDefinition)this.getDefinition()).getSuccessMappings());
        this.processTaskActor.completed(this.processOutputParameters);
    }

    protected final void raiseFault(String string) {
        this.transformRawParametersToProcessOutputParameters(((SubProcessDefinition)this.getDefinition()).getFailureMappings());
        this.processTaskActor.failed(string, this.processOutputParameters);
    }

    protected void raiseFault(String string, Throwable throwable) {
        this.setFault(Value.convert(throwable));
        this.raiseFault(string);
    }

    protected void setFault(Value<?> value) {
        String string = "exception";
        this.rawOutputParameters.put(string, value);
        this.processOutputParameters.put(string, value);
    }

    public void resetOutput() {
        ((Map)this.rawOutputParameters.getValue()).clear();
        ((Map)this.processOutputParameters.getValue()).clear();
    }

    protected void transformRawParametersToProcessOutputParameters(Collection<SubProcessOutputMappingDefinition> collection) {
        this.processTaskActor.addDebugInfo(() -> "Found " + collection.size() + " output parameter mappings", new Object[0]);
        for (SubProcessOutputMappingDefinition subProcessOutputMappingDefinition : collection) {
            String string = subProcessOutputMappingDefinition.getTarget().getName();
            this.processTaskActor.addDebugInfo(() -> "Mapping " + subProcessOutputMappingDefinition.getSource().getName() + " to " + subProcessOutputMappingDefinition.getTarget().getName(), new Object[0]);
            Value<?> value = subProcessOutputMappingDefinition.transformOutput(this.processTaskActor, this.rawOutputParameters);
            this.setProcessOutputParameter(string, value);
        }
    }

    protected void setRawOutputParameter(String string, Value<?> value) {
        this.rawOutputParameters.put(string, value);
    }

    protected void setProcessOutputParameter(String string, Value<?> value) {
        this.processOutputParameters.put(string, value);
    }

    protected ValueMap getRawOutputParameters() {
        return this.rawOutputParameters;
    }

    protected ValueMap getProcessOutputParameters() {
        return this.processOutputParameters;
    }

    public abstract void start();

    public abstract void reactivate();

    public abstract void suspend();

    public abstract void terminate();

    public abstract void resume();

    public void migrateDefinition(SubProcessDefinition subProcessDefinition) {
        this.processTaskActor.addDebugInfo(() -> "Setting new " + subProcessDefinition.getClass().getSimpleName(), new Object[0]);
        this.setDefinition(subProcessDefinition);
    }
}

