/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.calculation;

import java.util.HashMap;
import java.util.Map;
import org.cafienne.cmmn.definition.parameter.OutputParameterDefinition;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.instance.task.process.ProcessTask;
import org.cafienne.json.Value;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.processtask.implementation.InlineSubProcess;
import org.cafienne.processtask.implementation.calculation.CalculationDefinition;
import org.cafienne.processtask.implementation.calculation.Result;
import org.cafienne.processtask.implementation.calculation.definition.source.SourceDefinition;
import org.cafienne.processtask.implementation.calculation.operation.Source;

public class Calculation
extends InlineSubProcess<CalculationDefinition> {
    private final Map<SourceDefinition, Source<?>> sources = new HashMap();

    public Calculation(ProcessTask processTask, CalculationDefinition calculationDefinition) {
        super(processTask, calculationDefinition);
    }

    public ProcessTask getTask() {
        return this.task;
    }

    @Override
    public void reactivate() {
        this.start();
    }

    @Override
    public void start() {
        ProcessDefinition processDefinition = ((CalculationDefinition)this.definition).getProcessDefinition();
        Map<String, OutputParameterDefinition> map = processDefinition.getOutputParameters();
        this.addDebugInfo(() -> processDefinition.getName() + ": running " + map.size() + " calculations for output parameters");
        try {
            map.forEach((string, outputParameterDefinition) -> {
                this.addDebugInfo(() -> "Calculating value for " + string);
                Source<?> source = this.getSource((String)string);
                if (source.isValid()) {
                    Result result = source.getResult();
                    Value<?> value = result.getValue();
                    this.getTask().getCaseInstance().addDebugInfo(() -> "Result for '" + string + "': ", value);
                    this.setProcessOutputParameter((String)string, value);
                } else {
                    this.addDebugInfo(() -> "Result for '" + string + "' is not applicable, hence not added to the output parameters");
                }
            });
            this.raiseComplete();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            this.raiseFault("Failure during calculations", invalidExpressionException);
        }
    }

    Source<?> getSource(String string) {
        return this.getSource(((CalculationDefinition)this.definition).getTarget(string));
    }

    public Source<?> getSource(SourceDefinition sourceDefinition) {
        Source<?> source = this.sources.get(sourceDefinition);
        if (source == null) {
            source = sourceDefinition.createInstance(this);
            this.sources.put(sourceDefinition, source);
        }
        return source;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void resume() {
    }
}

