/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.implementation.http.HTTPCallDefinition;
import org.cafienne.processtask.implementation.http.Result;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCall
extends SubProcess<HTTPCallDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(HTTPCall.class);
    private final Result result = new Result(this);

    public HTTPCall(ProcessTaskActor processTaskActor, HTTPCallDefinition hTTPCallDefinition) {
        super(processTaskActor, hTTPCallDefinition);
    }

    @Override
    public void reactivate() {
        this.start();
    }

    @Override
    public void start() {
        boolean bl = this.runCall();
        this.processTaskActor.addDebugInfo(this.result::getDebugInfo, new Object[0]);
        this.getRawOutputParameters().merge(this.result.toJSON());
        if (bl) {
            this.raiseComplete();
        } else {
            this.setFault(this.result.getException());
            this.raiseFault(this.result.getErrorDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runCall() {
        Object object;
        HttpURLConnection httpURLConnection;
        URL uRL = ((HTTPCallDefinition)this.getDefinition()).getURL().resolveURL(this.processTaskActor);
        this.result.setTargetURL(uRL);
        String string = ((HTTPCallDefinition)this.getDefinition()).getMethod().resolve(this.processTaskActor, new String[0]);
        this.result.setRequestMethod(string);
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Could not create a connection with " + uRL, iOException);
        }
        try {
            httpURLConnection.setRequestMethod(string);
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Cannot set http method " + string, iOException);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        ((HTTPCallDefinition)this.getDefinition()).getHeaders(this.processTaskActor).forEach(header -> linkedHashMap.put(header.getName(), header.getValue()));
        this.result.setRequestHeaders(linkedHashMap);
        linkedHashMap.forEach(httpURLConnection::setRequestProperty);
        if (string.equalsIgnoreCase("POST") || string.equalsIgnoreCase("PUT")) {
            object = ((HTTPCallDefinition)this.getDefinition()).getContent().resolve(this.processTaskActor, new Object[0]).toString();
            this.result.setRequestPayload((String)object);
            if (((String)object).trim().length() > 0) {
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    dataOutputStream.writeBytes((String)object);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    return this.result.handleFailure("Failed to write content to " + uRL, iOException);
                }
            }
        }
        try {
            this.result.setResponseCode(httpURLConnection.getResponseCode());
            this.result.setResponseMessage(httpURLConnection.getResponseMessage());
            this.result.setResponseHeaders(httpURLConnection.getHeaderFields());
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Failed to read response", iOException);
        }
        if (this.result.isOutOf200Range()) {
            object = new StringBuilder();
            InputStream inputStream = null;
            try {
                int n;
                inputStream = httpURLConnection.getErrorStream();
                while (inputStream != null && (n = inputStream.read()) != -1) {
                    ((StringBuilder)object).append((char)n);
                }
                this.result.setResponsePayload(((StringBuilder)object).toString());
                boolean bl = this.result.handleFailure("Status code " + this.result.getCode() + " is interpreted as a failure");
                return bl;
            }
            catch (IOException iOException) {
                this.result.setResponsePayload(((StringBuilder)object).toString());
                boolean bl = this.result.handleFailure("Failed to read response payload for status code " + this.result.getCode(), iOException);
                return bl;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close the error stream", (Throwable)iOException);
                }
            }
        }
        try {
            int n;
            object = httpURLConnection.getInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = ((InputStream)object).read()) != -1) {
                stringBuilder.append((char)n);
            }
            this.result.setResponsePayload(stringBuilder.toString());
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Technical failure while reading http response although http code was " + this.result.getCode(), iOException);
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return true;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void resume() {
    }
}

