/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.stream.Stream;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.RandomUidGenerator;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.mail.Mail;
import org.cafienne.processtask.implementation.mail.MailAddress;

public class CalendarInvite {
    private final String invite;
    private final Mail mail;
    private final ValueMap input;

    public CalendarInvite(Mail mail, ValueMap valueMap) {
        this.mail = mail;
        this.input = valueMap;
        if (!valueMap.has("required") && !valueMap.has("optional")) {
            valueMap.put("required", valueMap.get("to"));
            valueMap.put("optional", valueMap.get("cc"));
        }
        Instant instant = valueMap.rawInstant("start", new Instant[0]);
        Instant instant2 = valueMap.rawInstant("end", new Instant[0]);
        String string = valueMap.has("timeZone") ? (String)valueMap.raw("timeZone") : ZoneId.systemDefault().toString();
        String string2 = valueMap.has("description") ? (String)valueMap.raw("description") : "";
        String string3 = valueMap.has("location") ? (String)valueMap.raw("location") : "";
        String string4 = valueMap.has("uid") ? (String)valueMap.raw("uid") : new RandomUidGenerator().generateUid().toString();
        instant.atZone(ZoneId.of(string));
        instant2.atZone(ZoneId.of(string));
        DateTime dateTime = new DateTime(Date.from((Instant)instant));
        DateTime dateTime2 = new DateTime(Date.from((Instant)instant2));
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, this.getEventName());
        vEvent.getProperties().add((Property)new Description(string2));
        vEvent.getProperties().add((Property)new Location(string3));
        TzId tzId = new TzId(string);
        vEvent.getProperties().add((Property)tzId);
        vEvent.getProperties().add((Property)new Uid(string4));
        this.getAttendees("required", mail.getToList()).peek(attendee -> attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT)).forEach(attendee -> vEvent.getProperties().add((Property)attendee));
        this.getAttendees("optional", mail.getCcList()).peek(attendee -> attendee.getParameters().add((Parameter)Role.OPT_PARTICIPANT)).forEach(attendee -> vEvent.getProperties().add((Property)attendee));
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Events Calendar//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        calendar.getComponents().add((Object)vEvent);
        this.invite = calendar.toString();
    }

    public BodyPart asPart() throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        String string = "invite.ics";
        String string2 = "text/calendar";
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(this.invite.getBytes(StandardCharsets.UTF_8), string2);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
        mimeBodyPart.setFileName(string);
        return mimeBodyPart;
    }

    private String getEventName() {
        if (this.input.has("meetingName")) {
            return this.input.get("meetingName").getValue().toString();
        }
        return this.mail.getSubject();
    }

    private Stream<Attendee> getAttendees(String string, List<MailAddress> list) {
        if (this.input.has(string)) {
            Value<?> value = this.input.get(string);
            ValueList valueList = value.isList() ? value.asList() : (value == Value.NULL ? new ValueList(new Object[0]) : new ValueList(new Object[]{value}));
            return ((List)valueList.getValue()).stream().map(MailAddress::new).map(MailAddress::asAttendee);
        }
        return list.stream().map(MailAddress::asAttendee);
    }
}

