/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail.definition;

import jakarta.mail.internet.InternetAddress;
import java.io.UnsupportedEncodingException;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.expression.spel.Resolver;
import org.cafienne.processtask.definition.ProcessInputResolver;
import org.cafienne.processtask.implementation.mail.InvalidMailAddressException;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.w3c.dom.Element;

public class AddressDefinition
extends ProcessInputResolver {
    private final Resolver emailResolver = this.getResolver();
    private final Resolver nameResolver = this.parseAttributeResolver("name", "");

    public AddressDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
    }

    public Resolver getEmailResolver() {
        return this.emailResolver;
    }

    public Resolver getNameResolver() {
        return this.nameResolver;
    }

    public InternetAddress toAddress(ProcessTaskActor processTaskActor) {
        String string = this.emailResolver.getValue(processTaskActor, "");
        String string2 = this.nameResolver.getValue(processTaskActor, "");
        try {
            return new InternetAddress(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidMailAddressException("Invalid email address " + string + " " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameAddressDefinition);
    }

    private boolean sameAddressDefinition(AddressDefinition addressDefinition) {
        return super.sameResolverDefinition(addressDefinition) && this.same(this.emailResolver, addressDefinition.emailResolver) && this.same(this.nameResolver, addressDefinition.nameResolver);
    }
}

