/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.report;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.cafienne.json.StringValue;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.implementation.report.MissingParameterException;
import org.cafienne.processtask.implementation.report.PDFReportDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class PDFReport
extends SubProcess<PDFReportDefinition> {
    static final String REPORT_DATA_TAG = "reportData";

    public PDFReport(ProcessTaskActor processTaskActor, PDFReportDefinition pDFReportDefinition) {
        super(processTaskActor, pDFReportDefinition);
    }

    @Override
    public void start() {
        this.generateReport();
    }

    @Override
    public void reactivate() {
        this.generateReport();
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void resume() {
    }

    private void generateReport() {
        try {
            long l = System.currentTimeMillis();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("JSON_INPUT_STREAM", ((PDFReportDefinition)this.getDefinition()).createDataStream(this));
            hashMap.put("net.sf.jasperreports.json.date.pattern", "yyyy-MM-dd");
            hashMap.put("net.sf.jasperreports.json.number.pattern", "#,##0.##");
            hashMap.put("JSON_LOCALE", Locale.ENGLISH);
            hashMap.put("REPORT_LOCALE", Locale.US);
            ((PDFReportDefinition)this.getDefinition()).getSubReportDefinitions().forEach(jasperSubReportDefinition -> {
                String string = jasperSubReportDefinition.getSubReportName();
                try {
                    JasperReport jasperReport = jasperSubReportDefinition.createInstance(this);
                    hashMap.put(string, jasperReport);
                }
                catch (JRException jRException) {
                    this.raiseFault("Could not compile parameter " + string + " into report definition", jRException);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.raiseFault(illegalArgumentException.getMessage(), illegalArgumentException);
                    return;
                }
            });
            JasperReport jasperReport = ((PDFReportDefinition)this.getDefinition()).getReportDefinition().createInstance(this);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)byteArrayOutputStream);
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            this.setRawOutputParameter("pdfReportData", new StringValue(string));
            this.processTaskActor.addDebugInfo(() -> "PDF Report - Filling time : " + (System.currentTimeMillis() - l), new Object[0]);
            this.raiseComplete();
        }
        catch (JRException jRException) {
            this.raiseFault("Error while generating pdf report", jRException);
        }
        catch (MissingParameterException missingParameterException) {
            this.raiseFault("Missing parameter", missingParameterException);
        }
    }

    ValueMap getInputParameters() {
        return this.processTaskActor.getMappedInputParameters();
    }
}

