/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.akkahttp;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.ServerBuilder;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RouteResult$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.akkahttp.route.CaseServiceRoute;
import org.cafienne.service.akkahttp.anonymous.AnonymousRequestRoutes;
import org.cafienne.service.akkahttp.cases.route.CasesRoutes;
import org.cafienne.service.akkahttp.consentgroup.route.ConsentGroupRoutes;
import org.cafienne.service.akkahttp.debug.DebugRoute;
import org.cafienne.service.akkahttp.identifiers.route.IdentifierRoutes;
import org.cafienne.service.akkahttp.platform.CaseEngineHealthRoute;
import org.cafienne.service.akkahttp.platform.PlatformRoutes;
import org.cafienne.service.akkahttp.repository.RepositoryRoute;
import org.cafienne.service.akkahttp.storage.StorageRoutes;
import org.cafienne.service.akkahttp.swagger.SwaggerHttpServiceRoute;
import org.cafienne.service.akkahttp.tasks.TaskRoutes;
import org.cafienne.service.akkahttp.tenant.route.TenantRoutes;
import org.cafienne.system.CaseSystem;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t4A\u0001C\u0005\u0001%!A1\u0005\u0001BC\u0002\u0013\u0005A\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u001d\t\u0004A1A\u0005\u0002IBa\u0001\u0012\u0001!\u0002\u0013\u0019\u0004\"B#\u0001\t\u00031\u0005\"\u0002'\u0001\t\u0003i%AE\"bM&,gN\\3IiR\u00048+\u001a:wKJT!AC\u0006\u0002\u0011\u0005\\7.\u00195uiBT!\u0001D\u0007\u0002\u000fM,'O^5dK*\u0011abD\u0001\tG\u00064\u0017.\u001a8oK*\t\u0001#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\"\u001b\u0005Y\"B\u0001\u000f\u001e\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tqr$\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0013aA2p[&\u0011!e\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0006dCN,7+_:uK6,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0003Q5\taa]=ti\u0016l\u0017B\u0001\u0016(\u0005)\u0019\u0015m]3TsN$X-\\\u0001\fG\u0006\u001cXmU=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003]A\u0002\"a\f\u0001\u000e\u0003%AQaI\u0002A\u0002\u0015\naA]8vi\u0016\u001cX#A\u001a\u0011\u0007QJ4(D\u00016\u0015\t1t'A\u0004nkR\f'\r\\3\u000b\u0005a*\u0012AC2pY2,7\r^5p]&\u0011!(\u000e\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bC\u0001\u001fC\u001b\u0005i$B\u0001 @\u0003\u0015\u0011x.\u001e;f\u0015\tQ\u0001I\u0003\u0002B\u001b\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017BA\">\u0005A\u0019\u0015m]3TKJ4\u0018nY3S_V$X-A\u0004s_V$Xm\u001d\u0011\u0002\u0011\u0005$GMU8vi\u0016$\"a\u0012&\u0011\u0005QA\u0015BA%\u0016\u0005\u0011)f.\u001b;\t\u000b-3\u0001\u0019A\u001e\u0002!\r\f7/Z*feZL7-\u001a*pkR,\u0017!B:uCJ$H#\u0001(\u0011\u0007=\u0013F+D\u0001Q\u0015\t\tV#\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0015)\u0003\r\u0019+H/\u001e:f!\t)vL\u0004\u0002W;6\tqK\u0003\u0002Y3\u0006A1oY1mC\u0012\u001cHN\u0003\u0002[7\u0006!\u0001\u000e\u001e;q\u0015\u0005a\u0016\u0001B1lW\u0006L!AX,\u0002\t!#H\u000f]\u0005\u0003A\u0006\u0014QbU3sm\u0016\u0014()\u001b8eS:<'B\u00010X\u0001")
public class CafienneHttpServer
implements LazyLogging {
    private final CaseSystem caseSystem;
    private final ListBuffer<CaseServiceRoute> routes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CafienneHttpServer cafienneHttpServer = this;
        synchronized (cafienneHttpServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    public ListBuffer<CaseServiceRoute> routes() {
        return this.routes;
    }

    public void addRoute(CaseServiceRoute caseServiceRoute) {
        this.routes().$plus$eq((Object)caseServiceRoute);
    }

    public Future<Http.ServerBinding> start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Cafienne HTTP Server - loading swagger documentation of the routes");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ListBuffer apiClasses = (ListBuffer)this.routes().flatMap((Function1 & Serializable)route -> route.apiClasses());
        ObjectRef mainRoute = ObjectRef.create(new SwaggerHttpServiceRoute(apiClasses.toSet()).route());
        ((IterableOnceOps)this.routes().map((Function1 & Serializable)x$1 -> x$1.route())).foreach((Function1 & Serializable)route -> {
            CafienneHttpServer.routeAppender$1(route, mainRoute);
            return BoxedUnit.UNIT;
        });
        Function1 apiRoutes = (Function1)mainRoute.elem;
        String apiHost = Cafienne$.MODULE$.config().api().bindHost();
        int apiPort = Cafienne$.MODULE$.config().api().bindPort();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Cafienne HTTP Server - starting akka http on {}:{}", new Object[]{apiHost, BoxesRunTime.boxToInteger((int)apiPort)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorSystem system = this.caseSystem().system();
        ServerBuilder akkaHttp = Http$.MODULE$.apply((ClassicActorSystemProvider)system).newServerAt(apiHost, apiPort);
        return akkaHttp.bindFlow(RouteResult$.MODULE$.routeToFlow(apiRoutes, (ClassicActorSystemProvider)system));
    }

    private static final void routeAppender$1(Function1 route, ObjectRef mainRoute$1) {
        mainRoute$1.elem = Directives$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1)mainRoute$1.elem, route}));
    }

    public CafienneHttpServer(CaseSystem caseSystem) {
        block0: {
            this.caseSystem = caseSystem;
            LazyLogging.$init$((LazyLogging)this);
            this.routes = new ListBuffer();
            this.addRoute(new CaseEngineHealthRoute(caseSystem));
            this.addRoute(new CasesRoutes(caseSystem));
            this.addRoute(new IdentifierRoutes(caseSystem));
            this.addRoute(new TaskRoutes(caseSystem));
            this.addRoute(new TenantRoutes(caseSystem));
            this.addRoute(new ConsentGroupRoutes(caseSystem));
            this.addRoute(new PlatformRoutes(caseSystem));
            this.addRoute(new RepositoryRoute(caseSystem));
            this.addRoute(new StorageRoutes(caseSystem));
            this.addRoute(new DebugRoute(caseSystem));
            if (!Cafienne$.MODULE$.config().api().anonymousConfig().enabled()) break block0;
            this.addRoute(new AnonymousRequestRoutes(caseSystem));
        }
    }
}

