/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage.archive.file;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.cafienne.infrastructure.config.engine.FileStorageConfig;
import org.cafienne.json.JSONReader;
import org.cafienne.json.ValueMap;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.archival.Archive;
import org.cafienne.storage.archival.Archive$;
import org.cafienne.storage.archive.Storage;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0003\u0006\u0001+!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u0003-\u0011\u00151\u0004\u0001\"\u00018\u0011\u001dY\u0004A1A\u0005\u0002qBa!\u0012\u0001!\u0002\u0013i\u0004\"\u0002$\u0001\t\u0003:\u0005\"B.\u0001\t\u0003a\u0006\"B3\u0001\t\u00032'\u0001\u0005$jY\u0016\u0014\u0015m]3e'R|'/Y4f\u0015\tYA\"\u0001\u0003gS2,'BA\u0007\u000f\u0003\u001d\t'o\u00195jm\u0016T!a\u0004\t\u0002\u000fM$xN]1hK*\u0011\u0011CE\u0001\tG\u00064\u0017.\u001a8oK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001-q\u0001\u0003CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\tA\"\u0003\u0002 \u0019\t91\u000b^8sC\u001e,\u0007CA\u0011)\u001b\u0005\u0011#BA\u0012%\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t)c%\u0001\u0005usB,7/\u00194f\u0015\u00059\u0013aA2p[&\u0011\u0011F\t\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004d_:4\u0017nZ\u000b\u0002YA\u0011QfM\u0007\u0002])\u0011q\u0006M\u0001\u0007K:<\u0017N\\3\u000b\u0005)\n$B\u0001\u001a\u0011\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!\u0001\u000e\u0018\u0003#\u0019KG.Z*u_J\fw-Z\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\tA$\b\u0005\u0002:\u00015\t!\u0002C\u0003+\u0007\u0001\u0007A&A\u0005eSJ,7\r^8ssV\tQ\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006\u0011\u0011n\u001c\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0003GS2,\u0017A\u00033je\u0016\u001cGo\u001c:zA\u0005)1\u000f^8sKR\u0011\u0001\n\u0016\t\u0004\u00132sU\"\u0001&\u000b\u0005-C\u0012AC2p]\u000e,(O]3oi&\u0011QJ\u0013\u0002\u0007\rV$XO]3\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bA!Y6lC&\u00111\u000b\u0015\u0002\u0005\t>tW\rC\u0003\u000e\r\u0001\u0007Q\u000b\u0005\u0002W36\tqK\u0003\u0002Y\u001d\u0005A\u0011M]2iSZ\fG.\u0003\u0002[/\n9\u0011I]2iSZ,\u0017aB4fi\u001aKG.\u001a\u000b\u0003{uCQAX\u0004A\u0002}\u000b\u0001\"\\3uC\u0012\fG/\u0019\t\u0003A\u000el\u0011!\u0019\u0006\u0003E:\t!\"Y2u_Jlw\u000eZ3m\u0013\t!\u0017MA\u0007BGR|'/T3uC\u0012\fG/Y\u0001\te\u0016$(/[3wKR\u0011q\r\u001b\t\u0004\u00132+\u0006\"\u00020\t\u0001\u0004y\u0006")
public class FileBasedStorage
implements Storage,
LazyLogging {
    private final FileStorageConfig config;
    private final File directory;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        FileBasedStorage fileBasedStorage = this;
        synchronized (fileBasedStorage) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public FileStorageConfig config() {
        return this.config;
    }

    public File directory() {
        return this.directory;
    }

    @Override
    public Future<Done> store(Archive archive) {
        BoxedUnit boxedUnit;
        File file = this.getFile(archive.metadata());
        FileWriter writer = new FileWriter(file, true);
        writer.write(archive.toString());
        writer.close();
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Wrote archive to disk: {}", (Object)file.getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public File getFile(ActorMetadata metadata) {
        String fileName = File.separator + "archive-" + metadata.actorType().toLowerCase() + "-" + metadata.actorId() + ".json";
        return new File(this.directory().getAbsolutePath() + fileName);
    }

    @Override
    public Future<Archive> retrieve(ActorMetadata metadata) {
        File file = this.getFile(metadata);
        ValueMap json = (ValueMap)JSONReader.parse(new FileInputStream(file));
        return Future$.MODULE$.successful((Object)Archive$.MODULE$.deserialize(json));
    }

    public FileBasedStorage(FileStorageConfig config) {
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        this.directory = config.directory();
    }
}

