/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.system.router;

import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.Terminated;
import java.io.Serializable;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.command.TerminateModelActor;
import org.cafienne.actormodel.response.ActorTerminated;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.router.CaseMessageRouter;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r4A!\u0003\u0006\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!Y\u0004A!A!\u0002\u0013q\u0002\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002\"\u0001\t\u0003\u001a\u0005\"\u0002*\u0001\t\u0013\u0019\u0006\"B+\u0001\t\u00032\u0006\"\u0002/\u0001\t\u0003j&a\u0003'pG\u0006d'k\\;uKJT!a\u0003\u0007\u0002\rI|W\u000f^3s\u0015\tia\"\u0001\u0004tsN$X-\u001c\u0006\u0003\u001fA\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AC\u0005\u0003/)\u0011\u0011cQ1tK6+7o]1hKJ{W\u000f^3s\u0003)\u0019\u0017m]3TsN$X-\u001c\t\u00035mi\u0011\u0001D\u0005\u000391\u0011!bQ1tKNK8\u000f^3n\u0003\u0019\t7\r^8sgB!qD\n\u00154\u001b\u0005\u0001#BA\u0011#\u0003\u001diW\u000f^1cY\u0016T!a\t\u0013\u0002\u0015\r|G\u000e\\3di&|gNC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9\u0003EA\u0002NCB\u0004\"!\u000b\u0019\u000f\u0005)r\u0003CA\u0016%\u001b\u0005a#BA\u0017\u0013\u0003\u0019a$o\\8u}%\u0011q\u0006J\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020IA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006C\u000e$xN\u001d\u0006\u0002q\u0005!\u0011m[6b\u0013\tQTG\u0001\u0005BGR|'OU3g\u0003M!XM]7j]\u0006$\u0018n\u001c8SKF,Xm\u001d;t\u0003\u0019a\u0014N\\5u}Q!ah\u0010!B!\t)\u0002\u0001C\u0003\u0019\t\u0001\u0007\u0011\u0004C\u0003\u001e\t\u0001\u0007a\u0004C\u0003<\t\u0001\u0007a$\u0001\bg_J<\u0018M\u001d3NKN\u001c\u0018mZ3\u0015\u0005\u0011C\u0005CA#G\u001b\u0005!\u0013BA$%\u0005\u0011)f.\u001b;\t\u000b%+\u0001\u0019\u0001&\u0002\u00035\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u000f\r|W.\\1oI*\u0011qJD\u0001\u000bC\u000e$xN]7pI\u0016d\u0017BA)M\u00051iu\u000eZ3m\u0007>lW.\u00198e\u00039\u0019'/Z1uK\u0006\u001bGo\u001c:SK\u001a$\"a\r+\t\u000b%3\u0001\u0019\u0001&\u0002\u001dQ,'/\\5oCR,\u0017i\u0019;peR\u0011Ai\u0016\u0005\u00061\u001e\u0001\r!W\u0001\u0004[N<\u0007CA&[\u0013\tYFJA\nUKJl\u0017N\\1uK6{G-\u001a7BGR|'/\u0001\bsK6|g/Z!di>\u0014(+\u001a4\u0015\u0005\u0011s\u0006\"B0\t\u0001\u0004\u0001\u0017!\u0001;\u0011\u0005Q\n\u0017B\u000126\u0005)!VM]7j]\u0006$X\r\u001a")
public class LocalRouter
extends CaseMessageRouter {
    private final CaseSystem caseSystem;
    private final Map<String, ActorRef> actors;
    private final Map<String, ActorRef> terminationRequests;

    @Override
    public void forwardMessage(ModelCommand m) {
        ((ActorRef)this.actors.getOrElseUpdate((Object)m.actorId(), (Function0 & Serializable)() -> this.createActorRef(m))).forward((Object)m, this.context());
    }

    private ActorRef createActorRef(ModelCommand m) {
        ActorRef ref = this.context().actorOf(Props$.MODULE$.create(m.actorClass(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.caseSystem})), m.actorId());
        this.context().watch(ref);
        return ref;
    }

    @Override
    public void terminateActor(TerminateModelActor msg) {
        String actorId = msg.actorId();
        this.actors.get((Object)actorId).fold((Function0)(JFunction0.mcV.sp & Serializable)() -> this.sender().$bang((Object)new ActorTerminated(actorId), this.self()), (Function1 & Serializable)actor -> {
            LocalRouter.$anonfun$terminateActor$2(this, actorId, actor);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void removeActorRef(Terminated t) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String actorId = t.actor().path().name();
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("ModelActor[" + actorId + "] has been terminated. Removing routing reference");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.actors.remove((Object)actorId).isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Received a Termination message for actor " + actorId + ", but it was not registered in the LocalRoutingService. Termination message is ignored");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.terminationRequests.remove((Object)actorId).foreach((Function1 & Serializable)requester -> {
            requester.$bang((Object)new ActorTerminated(actorId), this.self());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$terminateActor$2(LocalRouter $this, String actorId$1, ActorRef actor) {
        $this.terminationRequests.put((Object)actorId$1, (Object)$this.sender());
        $this.context().stop(actor);
    }

    public LocalRouter(CaseSystem caseSystem, Map<String, ActorRef> actors, Map<String, ActorRef> terminationRequests) {
        BoxedUnit boxedUnit;
        this.caseSystem = caseSystem;
        this.actors = actors;
        this.terminationRequests = terminationRequests;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting case system in local mode, opening router for {}", (Object)this.self().path().name());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

