/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.cmmn.actorapi.command.platform.NewUserInformation;
import org.cafienne.cmmn.actorapi.command.platform.PlatformUpdate;
import org.cafienne.system.CaseSystem;
import org.cafienne.tenant.actorapi.command.TenantCommand;
import org.cafienne.tenant.actorapi.event.TenantAppliedPlatformUpdate;
import org.cafienne.tenant.actorapi.event.TenantEvent;
import org.cafienne.tenant.actorapi.event.TenantModified;
import org.cafienne.tenant.actorapi.event.deprecated.DeprecatedTenantUserEvent;
import org.cafienne.tenant.actorapi.event.platform.TenantCreated;
import org.cafienne.tenant.actorapi.event.platform.TenantDisabled;
import org.cafienne.tenant.actorapi.event.platform.TenantEnabled;
import org.cafienne.tenant.actorapi.event.user.TenantUserAdded;
import org.cafienne.tenant.actorapi.event.user.TenantUserChanged;
import org.cafienne.tenant.actorapi.event.user.TenantUserRemoved;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantActor
extends ModelActor {
    private static final Logger logger = LoggerFactory.getLogger(TenantActor.class);
    private TenantCreated creationEvent;
    private final Map<String, TenantUser> users = new HashMap<String, TenantUser>();
    private boolean disabled = false;

    public TenantActor(CaseSystem caseSystem) {
        super(caseSystem);
    }

    @Override
    protected boolean supportsCommand(Object object) {
        return object instanceof TenantCommand;
    }

    @Override
    protected boolean supportsEvent(ModelEvent modelEvent) {
        return modelEvent instanceof TenantEvent;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public boolean exists() {
        return this.creationEvent != null;
    }

    public void createInstance(List<TenantUser> list) {
        this.addEvent(new TenantCreated(this));
        this.replaceInstance(list);
    }

    public void replaceInstance(List<TenantUser> list) {
        this.users.keySet().stream().filter(string -> list.stream().noneMatch(tenantUser -> tenantUser.id().equals(string))).collect(Collectors.toList()).forEach(this::removeUser);
        list.forEach(this::setUser);
    }

    public void removeUser(String string) {
        TenantUser tenantUser = this.users.get(string);
        if (tenantUser != null) {
            this.addEvent(new TenantUserRemoved(this, tenantUser));
        }
    }

    public void setUser(TenantUser tenantUser) {
        TenantUser tenantUser2 = this.users.get(tenantUser.id());
        if (tenantUser2 == null) {
            this.addEvent(new TenantUserAdded(this, tenantUser));
        } else if (tenantUser2.differs(tenantUser)) {
            Set<String> set = tenantUser2.getRoles().stream().filter(string -> !tenantUser.roles().contains(string)).collect(Collectors.toSet());
            this.addEvent(new TenantUserChanged(this, tenantUser, set));
        }
    }

    public void updateState(TenantAppliedPlatformUpdate tenantAppliedPlatformUpdate) {
        HashMap hashMap = new HashMap();
        tenantAppliedPlatformUpdate.newUserInformation.info().foreach(newUserInformation -> {
            TenantUser tenantUser = this.users.remove(newUserInformation.existingUserId());
            if (tenantUser != null) {
                this.users.put(newUserInformation.newUserId(), newUserInformation.copyTo(tenantUser));
                hashMap.put(newUserInformation.existingUserId(), newUserInformation);
            } else {
                NewUserInformation newUserInformation2 = (NewUserInformation)hashMap.get(newUserInformation.existingUserId());
                if (newUserInformation2 != null) {
                    logger.warn("Not updating user id " + newUserInformation.existingUserId() + " to " + newUserInformation.newUserId() + ", because a user with this id has just now been updated to " + newUserInformation2.newUserId());
                } else {
                    logger.warn("Not updating user id " + newUserInformation.existingUserId() + " to " + newUserInformation.newUserId() + ", because a user with this id is not found in the tenant.");
                }
            }
            return newUserInformation;
        });
    }

    public void updateState(TenantCreated tenantCreated) {
        this.setEngineVersion(tenantCreated.engineVersion);
        this.creationEvent = tenantCreated;
    }

    public void updateState(TenantUserAdded tenantUserAdded) {
        this.users.put(tenantUserAdded.memberId, tenantUserAdded.member);
    }

    public void updateState(TenantUserChanged tenantUserChanged) {
        this.users.put(tenantUserChanged.memberId, tenantUserChanged.member);
    }

    public void updateState(TenantUserRemoved tenantUserRemoved) {
        this.users.remove(tenantUserRemoved.memberId);
    }

    public void disable() {
        if (!this.disabled) {
            this.addEvent(new TenantDisabled(this));
        }
    }

    public void enable() {
        if (this.disabled) {
            this.addEvent(new TenantEnabled(this));
        }
    }

    public void updateState(TenantDisabled tenantDisabled) {
        this.disabled = true;
    }

    public void updateState(TenantEnabled tenantEnabled) {
        this.disabled = false;
    }

    public TenantUser getUser(String string) {
        return this.users.get(string);
    }

    public boolean isOwner(String string) {
        TenantUser tenantUser = this.getUser(string);
        return tenantUser != null && tenantUser.isOwner();
    }

    public boolean isOwner(TenantUser tenantUser) {
        return this.isOwner(tenantUser.id());
    }

    public List<String> getOwnerList() {
        return this.users.values().stream().filter(TenantUser::isOwner).filter(TenantUser::enabled).map(TenantUser::id).collect(Collectors.toList());
    }

    public void updateState(DeprecatedTenantUserEvent deprecatedTenantUserEvent) {
        TenantUser.handleDeprecatedEvent(this.users, deprecatedTenantUserEvent);
    }

    public void updatePlatformInformation(PlatformUpdate platformUpdate) {
        this.addEvent(new TenantAppliedPlatformUpdate(this, platformUpdate));
    }

    @Override
    protected void addCommitEvent(IncomingActorMessage incomingActorMessage) {
        this.addEvent(new TenantModified(this, incomingActorMessage));
    }
}

