/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant.actorapi.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cafienne.actormodel.command.BaseModelCommand;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.TenantMessage;
import org.cafienne.tenant.actorapi.exception.TenantException;
import org.cafienne.tenant.actorapi.response.TenantResponse;

public abstract class TenantCommand
extends BaseModelCommand<TenantActor, TenantUser>
implements TenantMessage {
    protected TenantCommand(TenantUser tenantUser, String string) {
        super(tenantUser, string);
    }

    protected TenantCommand(ValueMap valueMap) {
        super(valueMap);
    }

    @Override
    protected TenantUser readUser(ValueMap valueMap) {
        return TenantUser.deserialize(valueMap);
    }

    @Override
    public void validate(TenantActor tenantActor) throws InvalidCommandException {
        if (!tenantActor.exists()) {
            throw new TenantException("Not allowed to access this tenant");
        }
        if (!tenantActor.isOwner((TenantUser)this.getUser())) {
            throw new AuthorizationException("You do not have the privileges to perform this action");
        }
    }

    protected void validateUserList(List<TenantUser> list) {
        Set set = list.stream().map(TenantUser::id).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (set.size() > 0) {
            throw new TenantException("Cannot set tenant with user duplicates. Found multiple entries for users " + set);
        }
        if (list.stream().noneMatch(tenantUser -> tenantUser.isOwner() && tenantUser.enabled())) {
            throw new TenantException("Cannot set tenant without active tenant owners");
        }
    }

    protected void validateNotLastOwner(TenantActor tenantActor, String string) {
        List<String> list = tenantActor.getOwnerList();
        if (list.size() == 1 && list.contains(string)) {
            throw new TenantException("Cannot remove tenant ownership or disable the account. There must be at least one tenant owner.");
        }
    }

    @Override
    public void process(TenantActor tenantActor) {
        this.processTenantCommand(tenantActor);
        if (this.hasNoResponse()) {
            this.setResponse(new TenantResponse(this));
        }
    }

    protected abstract void processTenantCommand(TenantActor var1);
}

