/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice.persistence.cassandra;

import akka.Done;
import akka.Done$;
import akka.persistence.cassandra.query.scaladsl.CassandraReadJournal;
import akka.persistence.query.Offset;
import akka.persistence.query.Offset$;
import akka.persistence.query.TimeBasedUUID;
import akka.util.Timeout;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.cql.SyncCqlSession;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import org.cafienne.infrastructure.cqrs.offset.OffsetRecord;
import org.cafienne.infrastructure.cqrs.offset.OffsetRecord$;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.persistence.TimerStore;
import org.cafienne.timerservice.persistence.cassandra.CassandraTimerStore$Schema$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\r\u001a\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019q\u0005\u0001)A\u0005\u0007\"9q\n\u0001b\u0001\n\u0003\u0011\u0005B\u0002)\u0001A\u0003%1\tC\u0004R\u0001\t\u0007I\u0011\u0001\"\t\rI\u0003\u0001\u0015!\u0003D\u0011\u001d\u0019\u0006A1A\u0005\u0002QCaa\u0017\u0001!\u0002\u0013)\u0006b\u0002/\u0001\u0005\u0004%\u0019%\u0018\u0005\u0007I\u0002\u0001\u000b\u0011\u00020\t\u000b\u0015\u0004A\u0011\t4\t\u000b=\u0004A\u0011\t9\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA-\u0001\u0011%\u00111\f\u0005\b\u0003?\u0002A\u0011IA1\u0011\u001d\tI\u0007\u0001C!\u0003W:q!a\u001e\u0001\u0011\u0003\tIHB\u0004\u0002~\u0001A\t!a \t\rq*B\u0011AAA\u0011\u001d\t\u0019)\u0006C\u0001\u0003\u000b\u00131cQ1tg\u0006tGM]1US6,'o\u0015;pe\u0016T!AG\u000e\u0002\u0013\r\f7o]1oIJ\f'B\u0001\u000f\u001e\u0003-\u0001XM]:jgR,gnY3\u000b\u0005yy\u0012\u0001\u0004;j[\u0016\u00148/\u001a:wS\u000e,'B\u0001\u0011\"\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y5j\u0011aG\u0005\u0003]m\u0011!\u0002V5nKJ\u001cFo\u001c:f\u0003-\u0011X-\u00193K_V\u0014h.\u00197\u0011\u0005ERT\"\u0001\u001a\u000b\u0005M\"\u0014\u0001C:dC2\fGm\u001d7\u000b\u0005U2\u0014!B9vKJL(B\u0001\u000e8\u0015\ta\u0002HC\u0001:\u0003\u0011\t7n[1\n\u0005m\u0012$\u0001F\"bgN\fg\u000e\u001a:b%\u0016\fGMS8ve:\fG.\u0001\u0004=S:LGO\u0010\u000b\u0003}\u0001\u0003\"a\u0010\u0001\u000e\u0003eAQa\f\u0002A\u0002A\n\u0001b[3zgB\f7-Z\u000b\u0002\u0007B\u0011Ai\u0013\b\u0003\u000b&\u0003\"AR\u0014\u000e\u0003\u001dS!\u0001S\u0012\u0002\rq\u0012xn\u001c;?\u0013\tQu%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u0013aa\u0015;sS:<'B\u0001&(\u0003%YW-_:qC\u000e,\u0007%\u0001\u0006uS6,'\u000fV1cY\u0016\f1\u0002^5nKJ$\u0016M\u00197fA\u0005YqN\u001a4tKR$\u0016M\u00197f\u00031ygMZ:fiR\u000b'\r\\3!\u0003A\u0019\u0017m]:b]\u0012\u0014\u0018\rV5nK>,H/F\u0001V!\t1\u0016,D\u0001X\u0015\tA\u0006(\u0001\u0003vi&d\u0017B\u0001.X\u0005\u001d!\u0016.\\3pkR\f\u0011cY1tg\u0006tGM]1US6,w.\u001e;!\u0003\t)7-F\u0001_!\ty&-D\u0001a\u0015\t\tw%\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u00191\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005Iq-\u001a;PM\u001a\u001cX\r^\u000b\u0002OB\u0019q\f\u001b6\n\u0005%\u0004'A\u0002$viV\u0014X\r\u0005\u0002l[6\tAN\u0003\u00026o%\u0011a\u000e\u001c\u0002\u0007\u001f\u001a47/\u001a;\u0002\u0013\u001d,G\u000fV5nKJ\u001cHCA9\u0000!\ry\u0006N\u001d\t\u0004gb\\hB\u0001;w\u001d\t1U/C\u0001)\u0013\t9x%A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(aA*fc*\u0011qo\n\t\u0003yvl\u0011!H\u0005\u0003}v\u0011Q\u0001V5nKJDq!!\u0001\u000f\u0001\u0004\t\u0019!\u0001\u0004xS:$wn\u001e\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011!\u0018.\\3\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006LA!!\u0005\u0002\b\t9\u0011J\\:uC:$\u0018AC:u_J,G+[7feR1\u0011qCA\u0011\u0003K\u0001Ba\u00185\u0002\u001aA!\u00111DA\u000f\u001b\u0005A\u0014bAA\u0010q\t!Ai\u001c8f\u0011\u0019\t\u0019c\u0004a\u0001w\u0006\u0019!n\u001c2\t\u000f\u0005\u001dr\u00021\u0001\u0002*\u00051qN\u001a4tKR\u0004BAJA\u0016U&\u0019\u0011QF\u0014\u0003\r=\u0003H/[8o\u0003I9W\r^%og\u0016\u0014Ho\u0015;bi\u0016lWM\u001c;\u0015\t\u0005M\u0012q\u000b\t\u0005\u0003k\t\u0019&\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\r\u0019\u0017\u000f\u001c\u0006\u0005\u0003{\ty$\u0001\u0003d_J,'\u0002BA!\u0003\u0007\n1!\u00199j\u0015\u0011\t)%a\u0012\u0002\r\u0011\u0014\u0018N^3s\u0015\u0011\tI%a\u0013\u0002\u0007=\u001c8O\u0003\u0003\u0002N\u0005=\u0013\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0005\u0005E\u0013aA2p[&!\u0011QKA\u001c\u0005=\u0019\u0016.\u001c9mKN#\u0018\r^3nK:$\bBBA\u0012!\u0001\u000710A\bhKR|eMZ:fi&s7/\u001a:u)\u0011\t\u0019$!\u0018\t\r\u0005\u001d\u0012\u00031\u0001k\u0003-\u0011X-\\8wKRKW.\u001a:\u0015\r\u0005]\u00111MA4\u0011\u0019\t)G\u0005a\u0001\u0007\u00069A/[7fe&#\u0007bBA\u0014%\u0001\u0007\u0011\u0011F\u0001\rS6\u0004xN\u001d;US6,'o\u001d\u000b\u0005\u0003[\n\u0019\bE\u0002'\u0003_J1!!\u001d(\u0005\u0011)f.\u001b;\t\r\u0005U4\u00031\u0001s\u0003\u0011a\u0017n\u001d;\u0002\rM\u001b\u0007.Z7b!\r\tY(F\u0007\u0002\u0001\t11k\u00195f[\u0006\u001c\"!F\u0013\u0015\u0005\u0005e\u0014\u0001D2sK\u0006$XmU2iK6\fG\u0003BA7\u0003\u000fCq!!#\u0018\u0001\u0004\tY)A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005U\u0012QR\u0005\u0005\u0003\u001f\u000b9D\u0001\bTs:\u001c7)\u001d7TKN\u001c\u0018n\u001c8")
public class CassandraTimerStore
implements TimerStore {
    private volatile CassandraTimerStore$Schema$ Schema$module;
    private final CassandraReadJournal readJournal;
    private final String keyspace;
    private final String timerTable;
    private final String offsetTable;
    private final Timeout cassandraTimeout;
    private final ExecutionContext ec;
    private String storageName;
    private String description;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public CassandraTimerStore$Schema$ Schema() {
        if (this.Schema$module == null) {
            this.Schema$lzycompute$1();
        }
        return this.Schema$module;
    }

    @Override
    public String storageName() {
        return this.storageName;
    }

    private String description$lzycompute() {
        CassandraTimerStore cassandraTimerStore = this;
        synchronized (cassandraTimerStore) {
            if (!this.bitmap$0) {
                this.description = TimerStore.description$(this);
                this.bitmap$0 = true;
            }
        }
        return this.description;
    }

    @Override
    public String description() {
        if (!this.bitmap$0) {
            return this.description$lzycompute();
        }
        return this.description;
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$ec_$eq(ExecutionContext x$1) {
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$storageName_$eq(String x$1) {
        this.storageName = x$1;
    }

    private Logger logger$lzycompute() {
        CassandraTimerStore cassandraTimerStore = this;
        synchronized (cassandraTimerStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String timerTable() {
        return this.timerTable;
    }

    public String offsetTable() {
        return this.offsetTable;
    }

    public Timeout cassandraTimeout() {
        return this.cassandraTimeout;
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Future<Offset> getOffset() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Reading timer offset from Cassandra");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleStatement offsetQuery = ((Select)QueryBuilder.selectFrom((String)this.keyspace(), (String)this.offsetTable()).all().whereColumn("name").isEqualTo((Term)QueryBuilder.literal((Object)this.storageName()))).allowFiltering().build();
        return this.readJournal.session().selectOne((Statement)offsetQuery).map((Function1 & Serializable)result -> (Offset)result.fold((Function0 & Serializable)() -> Offset$.MODULE$.noOffset(), (Function1 & Serializable)row -> new TimeBasedUUID(UUID.fromString(row.getString("offset_value")))), this.ec());
    }

    @Override
    public Future<Seq<Timer>> getTimers(Instant window) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reading existing timers from Cassandra database for window {}", (Object)window);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleStatement select = ((Select)QueryBuilder.selectFrom((String)this.keyspace(), (String)this.timerTable()).all().whereColumn("moment").isLessThan((Term)QueryBuilder.literal((Object)window))).allowFiltering().build();
        return this.readJournal.session().selectAll((Statement)select).map((Function1 & Serializable)rows -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Found " + rows.length() + " timers");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (Seq)((IterableOps)rows.map((Function1 & Serializable)row -> {
                String timerId = row.getString("timerid");
                String caseInstanceId = row.getString("caseinstanceid");
                String tenant = row.getString("tenant");
                String userId = row.getString("user");
                Instant moment = row.getInstant("moment");
                if (timerId == null || caseInstanceId == null || tenant == null || userId == null || moment == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Cassandra database table contains an invalid record ({}, {}, {}, {}, {}). Record will be ignored", new Object[]{timerId, caseInstanceId, tenant, userId, moment});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return null;
                }
                return new Timer(caseInstanceId, timerId, moment, userId);
            })).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CassandraTimerStore.$anonfun$getTimers$3(x$2)));
        }, this.ec());
    }

    @Override
    public Future<Done> storeTimer(Timer job, Option<Offset> offset2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Storing timer into Cassandra timer table " + job);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BatchStatementBuilder batch = BatchStatement.builder((BatchType)BatchType.LOGGED).addStatement((BatchableStatement)this.getInsertStatement(job));
        offset2.foreach((Function1 & Serializable)offset -> batch.addStatement((BatchableStatement)this.getOffsetInsert((Offset)offset)));
        return this.readJournal.session().executeWriteBatch(batch.build()).map((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Stored timer " + job);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Done$.MODULE$;
        }, this.ec());
    }

    private SimpleStatement getInsertStatement(Timer job) {
        SimpleStatement insert = QueryBuilder.insertInto((String)this.keyspace(), (String)this.timerTable()).value("timerid", (Term)QueryBuilder.literal((Object)job.timerId())).value("caseinstanceid", (Term)QueryBuilder.literal((Object)job.caseInstanceId())).value("tenant", (Term)QueryBuilder.literal((Object)"")).value("user", (Term)QueryBuilder.literal((Object)job.userId())).value("moment", (Term)QueryBuilder.literal((Object)job.moment())).build();
        return insert;
    }

    private SimpleStatement getOffsetInsert(Offset offset) {
        OffsetRecord offsetRecord = OffsetRecord$.MODULE$.apply(this.storageName(), offset);
        SimpleStatement insert = QueryBuilder.insertInto((String)this.keyspace(), (String)this.offsetTable()).value("name", (Term)QueryBuilder.literal((Object)this.storageName())).value("offset_type", (Term)QueryBuilder.literal((Object)offsetRecord.offsetType())).value("offset_value", (Term)QueryBuilder.literal((Object)offsetRecord.offsetValue())).value("modified", (Term)QueryBuilder.literal((Object)Instant.now())).build();
        return insert;
    }

    @Override
    public Future<Done> removeTimer(String timerId, Option<Offset> offset2) {
        BoxedUnit boxedUnit;
        SimpleStatement delete = ((BuildableQuery)QueryBuilder.deleteFrom((String)this.keyspace(), (String)this.timerTable()).whereColumn("timerId").isEqualTo((Term)QueryBuilder.literal((Object)timerId))).build();
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Removing timer {} from Cassandra database with statement {}", new Object[]{timerId, delete});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BatchStatementBuilder batch = BatchStatement.builder((BatchType)BatchType.LOGGED).addStatement((BatchableStatement)delete);
        offset2.foreach((Function1 & Serializable)offset -> batch.addStatement((BatchableStatement)this.getOffsetInsert((Offset)offset)));
        return this.readJournal.session().executeWriteBatch(batch.build()).map((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Removed timer {} from Cassandra database", (Object)timerId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Done$.MODULE$;
        }, this.ec());
    }

    @Override
    public void importTimers(Seq<Timer> list) {
        BatchStatementBuilder batch = BatchStatement.builder((BatchType)BatchType.LOGGED);
        ((IterableOnceOps)list.map((Function1 & Serializable)job -> this.getInsertStatement((Timer)job))).foreach((Function1 & Serializable)x$1 -> batch.addStatement(x$1));
        Await$.MODULE$.result((Awaitable)this.readJournal.session().executeWriteBatch(batch.build()), (Duration)this.cassandraTimeout().duration());
    }

    private final void Schema$lzycompute$1() {
        CassandraTimerStore cassandraTimerStore = this;
        synchronized (cassandraTimerStore) {
            if (this.Schema$module == null) {
                this.Schema$module = new CassandraTimerStore$Schema$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(CassandraTimerStore $this, CqlSession x$1) {
        $this.Schema().createSchema((SyncCqlSession)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getTimers$3(Timer x$2) {
        return x$2 != null;
    }

    public CassandraTimerStore(CassandraReadJournal readJournal) {
        this.readJournal = readJournal;
        LazyLogging.$init$((LazyLogging)this);
        TimerStore.$init$(this);
        this.keyspace = "akka";
        this.timerTable = "cafienne_timer";
        this.offsetTable = "cafienne_timer_offset";
        this.cassandraTimeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(15)).seconds());
        this.ec = ExecutionContext$.MODULE$.global();
        Await$.MODULE$.result((Awaitable)readJournal.session().underlying().map((Function1 & Serializable)x$1 -> {
            CassandraTimerStore.$anonfun$new$1(this, x$1);
            return BoxedUnit.UNIT;
        }, this.ec()), (Duration)this.cassandraTimeout().duration());
        Statics.releaseFence();
    }
}

