/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLHelper {
    public static String printXMLNode(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            String string = node instanceof Document || node == node.getOwnerDocument().getDocumentElement() ? "no" : "yes";
            transformer.setOutputProperty("omit-xml-declaration", string);
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            String string2 = stringWriter.getBuffer().toString();
            string2 = XMLHelper.removeEmptyLines(string2);
            return string2;
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    public static void persist(Node node, File file) throws IOException, TransformerException {
        String string = XMLHelper.printXMLNode(node);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string.getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static String removeEmptyLines(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = string.split("\n")) {
            if (string2.trim().isEmpty()) continue;
            if (string2.contains("&#13;")) {
                string2 = string2.replace("&#13;", "");
            }
            stringBuilder.append(string2).append("\n");
        }
        return stringBuilder.toString();
    }

    public static Document getXMLDocument(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        document.getDocumentElement().normalize();
        return document;
    }

    public static Document loadXML(String string) throws IOException, ParserConfigurationException, SAXException {
        return XMLHelper.loadXML(string.getBytes());
    }

    public static Document loadXML(byte[] byArray) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return XMLHelper.getXMLDocument(byteArrayInputStream);
    }

    public static List<Element> getChildrenWithTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getParentNode() != element) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static List<Element> getElementsNS(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getParentNode() != element) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static Element getElement(Element element, String string) {
        List<Element> list = XMLHelper.getChildrenWithTagName(element, string);
        if (list.isEmpty()) {
            return null;
        }
        return (Element)list.iterator().next();
    }

    public static Element getElementNS(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getParentNode() != element) continue;
            return element2;
        }
        return null;
    }

    public static Element findElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static String getContent(Element element, String string, String string2) {
        String string3;
        Element element2;
        Element element3 = element2 = string == null ? element : XMLHelper.getElement(element, string);
        if (element2 != null && !(string3 = XMLHelper.getTextOfChildren(element2)).isBlank()) {
            return string3;
        }
        return string2;
    }

    private static String getTextOfChildren(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof CDATASection) {
                stringBuilder.append(node.getNodeValue());
                continue;
            }
            if (node instanceof Text) {
                String string = node.getNodeValue();
                if (string.isBlank()) continue;
                stringBuilder.append(string);
                continue;
            }
            if (!(node instanceof Element)) continue;
            stringBuilder.append(XMLHelper.getTextOfChildren((Element)node));
        }
        return stringBuilder.toString();
    }
}

