/*
 * Copyright (C) 2014  Batav B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cafienne.consentgroup.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

import java.io.IOException;

/**
 * ConsentGroupEvents are generated by the {@link ConsentGroupActor}.
 */
public abstract class ConsentGroupMemberEvent extends ConsentGroupBaseEvent {
    public final String userId;
    public final ConsentGroupMember member;

    protected ConsentGroupMemberEvent(ConsentGroupActor group, ConsentGroupMember member) {
        super(group);
        this.userId = member.userId();
        this.member = member;
    }

    protected ConsentGroupMemberEvent(ValueMap json) {
        super(json);
        this.userId = json.readString(Fields.userId);
        this.member = json.readObject(Fields.member, ConsentGroupMember::deserialize);
    }

    @Override
    public String getDescription() {
        return super.getDescription() +" - " + userId;
    }

    public void writeConsentGroupMemberEvent(JsonGenerator generator) throws IOException {
        super.writeConsentGroupEvent(generator);
        writeField(generator, Fields.userId, userId);
        // TODO???: "flat map" the member fields, to make the event's json little more readable
        writeField(generator, Fields.member, member);
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        writeConsentGroupMemberEvent(generator);
    }
}
