/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.StagingArea;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.cmmn.instance.debug.DebugInfoAppender;
import org.cafienne.infrastructure.enginedeveloper.EngineDeveloperConsole;
import org.slf4j.Logger;

class Warehouse {
    private final ModelActor actor;
    private StagingArea staging;
    private boolean isOpen = false;

    Warehouse(ModelActor modelActor) {
        this.actor = modelActor;
    }

    StagingArea prepareNextShipment(IncomingActorMessage incomingActorMessage) {
        this.isOpen = true;
        this.actor.setCurrentUser(incomingActorMessage.getUser());
        this.staging = new StagingArea(this.actor, incomingActorMessage);
        return this.staging;
    }

    void storeEvent(ModelEvent modelEvent) {
        if (this.isOpen) {
            this.staging.addEvent(modelEvent);
        } else if (EngineDeveloperConsole.enabled()) {
            EngineDeveloperConsole.debugIndentedConsoleLogging("!!! Recovering " + this.actor + " generates event of type " + modelEvent.getClass().getSimpleName());
        }
    }

    void handlePersistFailure(Throwable throwable, Object object, long l) {
        if (this.isOpen) {
            this.staging.handlePersistFailure(throwable, object, l);
        }
    }

    void addDebugInfo(Logger logger, DebugInfoAppender debugInfoAppender, Object ... objectArray) {
        if (this.isOpen) {
            this.staging.addDebugInfo(logger, debugInfoAppender, objectArray);
        }
    }
}

