/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.command;

import akka.actor.ActorPath;
import akka.actor.ActorRef;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.ValueMap;
import org.cafienne.util.Guid;

public abstract class BaseModelCommand<T extends ModelActor, U extends UserIdentity>
implements ModelCommand {
    protected final String msgId;
    public final String actorId;
    public ActorRef sender;
    protected transient T actor;
    private ModelResponse response;
    private final U user;

    protected BaseModelCommand(U u, String string) {
        if (string == null) {
            throw new InvalidCommandException("Actor id cannot be null");
        }
        try {
            ActorPath.validatePathElement((String)string);
        }
        catch (Throwable throwable) {
            throw new InvalidCommandException("Invalid actor path " + string, throwable);
        }
        if (u == null || u.id() == null || u.id().trim().isEmpty()) {
            throw new InvalidCommandException("Tenant user cannot be null");
        }
        this.msgId = new Guid().toString();
        this.user = u;
        this.actorId = string;
    }

    protected BaseModelCommand(ValueMap valueMap) {
        this.msgId = valueMap.readString((Object)Fields.messageId, new String[0]);
        this.actorId = valueMap.readString((Object)Fields.actorId, new String[0]);
        this.user = this.readUser(valueMap.with((Object)Fields.user));
    }

    protected abstract U readUser(ValueMap var1);

    @Override
    public final void setActor(ModelActor modelActor) {
        this.actor = modelActor;
        this.sender = modelActor.getSender();
    }

    public ActorRef getSender() {
        return this.sender;
    }

    @Override
    public final void validateCommand(ModelActor modelActor) {
        this.validate(modelActor);
    }

    @Override
    public final void processCommand(ModelActor modelActor) {
        this.process(modelActor);
    }

    @Override
    public ModelResponse getResponse() {
        return this.response;
    }

    public void setResponse(ModelResponse modelResponse) {
        this.response = modelResponse;
    }

    @Override
    public boolean hasResponse() {
        return this.response != null;
    }

    protected boolean hasNoResponse() {
        return this.response == null;
    }

    public T getActor() {
        return this.actor;
    }

    public final U getUser() {
        return this.user;
    }

    @Override
    public final String getActorId() {
        return this.actorId;
    }

    @Override
    public String getMessageId() {
        return this.msgId;
    }

    public abstract void validate(T var1) throws InvalidCommandException;

    public abstract void process(T var1);

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeModelCommand(jsonGenerator);
    }

    protected void writeModelCommand(JsonGenerator jsonGenerator) throws IOException {
        this.writeField(jsonGenerator, (Object)Fields.messageId, this.getMessageId());
        this.writeField(jsonGenerator, (Object)Fields.actorId, this.getActorId());
        this.writeField(jsonGenerator, (Object)Fields.user, (CafienneJson)this.user);
    }

    @Override
    public String getCommandDescription() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return "Command [" + this.getCommandDescription() + "]" + super.toString();
    }
}

