/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.response;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.cafienne.cmmn.actorapi.response.InvalidCaseLastModifiedException;

public class ActorLastModified {
    private static final String SEPARATOR = ";";
    public final Instant lastModified;
    public final String actorId;
    private final String string;

    public ActorLastModified(String string, Instant instant) {
        this.lastModified = instant;
        this.actorId = string;
        this.string = this.asString();
    }

    private String asString() {
        return this.lastModified == null ? null : this.lastModified + SEPARATOR + this.actorId;
    }

    public ActorLastModified(String string, String string2) throws InvalidCaseLastModifiedException {
        try {
            String[] stringArray = string2.split(SEPARATOR);
            this.lastModified = Instant.parse(stringArray[0]);
            this.actorId = stringArray[1];
            this.string = this.asString();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | DateTimeParseException runtimeException) {
            if (runtimeException instanceof DateTimeParseException) {
                throw new InvalidCaseLastModifiedException("Invalid time stamp '" + ((DateTimeParseException)runtimeException).getParsedString() + "' received in " + string + " header");
            }
            throw new InvalidCaseLastModifiedException("Provide a valid " + string + " header");
        }
    }

    public String toString() {
        return this.string;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public String getActorId() {
        return this.actorId;
    }
}

