/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.snapshot;

import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.snapshot.ModelActorSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public abstract class RelaxedSnapshot<M extends ModelActor>
implements ModelActorSnapshot {
    private static final Logger logger = LoggerFactory.getLogger(RelaxedSnapshot.class);
    private final M actor;
    private final FiniteDuration delay;
    private TimedSnapshotSaver timedSnapshotSaver = null;

    protected RelaxedSnapshot(M m, FiniteDuration finiteDuration) {
        this.actor = m;
        this.delay = finiteDuration;
    }

    protected RelaxedSnapshot() {
        this.actor = null;
        this.delay = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableTimedSnapshotSaver() {
        RelaxedSnapshot relaxedSnapshot = this;
        synchronized (relaxedSnapshot) {
            if (this.timedSnapshotSaver != null) {
                ++this.timedSnapshotSaver.changes;
                return;
            }
            this.getLogger().debug("Saving snapshot in " + this.delay);
            this.timedSnapshotSaver = new TimedSnapshotSaver();
            this.timedSnapshotSaver.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String string) {
        RelaxedSnapshot relaxedSnapshot = this;
        synchronized (relaxedSnapshot) {
            this.getLogger().debug("Storage changed, saving snapshot - " + string);
            if (this.timedSnapshotSaver != null) {
                this.timedSnapshotSaver.aborted = true;
                this.timedSnapshotSaver = null;
            }
            this.actor.saveSnapshot((Object)this);
        }
    }

    protected Logger getLogger() {
        return logger;
    }

    class TimedSnapshotSaver
    extends Thread {
        int changes = 1;
        boolean aborted = false;

        TimedSnapshotSaver() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(RelaxedSnapshot.this.delay.toMillis());
                if (!this.aborted) {
                    RelaxedSnapshot.this.save("after delay of " + RelaxedSnapshot.this.delay + " in which " + this.changes + " changes occurred");
                }
            }
            catch (InterruptedException interruptedException) {
                RelaxedSnapshot.this.getLogger().debug("Received an interrupt; returning");
            }
        }
    }
}

