/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.plan.task;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class HandleTaskImplementationTransition
extends CaseCommand {
    protected final String taskId;
    private final Transition transition;
    protected Task<?> task;

    public HandleTaskImplementationTransition(ModelActor modelActor, Transition transition) {
        super(modelActor.getCurrentUser().asCaseUserIdentity(), modelActor.getParentActorId());
        this.taskId = modelActor.getId();
        this.transition = transition;
    }

    public HandleTaskImplementationTransition(ValueMap valueMap) {
        super(valueMap);
        this.taskId = valueMap.readString((Object)Fields.taskId, new String[0]);
        this.transition = valueMap.readEnum((Object)Fields.transition, Transition.class);
    }

    @Override
    public void validate(Case case_) {
        if (this.taskId == null || this.taskId.trim().isEmpty()) {
            throw new InvalidCommandException("Invalid or missing task id");
        }
        PlanItem<?> planItem = this.getPlanItem(case_);
        if (planItem == null) {
            throw new InvalidCommandException("Invalid or missing task id");
        }
        if (!(planItem instanceof Task)) {
            throw new InvalidCommandException("Invalid or missing task id");
        }
        this.task = (Task)planItem;
    }

    @Override
    public void processCaseCommand(Case case_) {
        this.task.handleImplementationTransition(this.transition);
    }

    private PlanItem<?> getPlanItem(Case case_) {
        return case_.getPlanItemById(this.taskId);
    }

    @Override
    public String toString() {
        String string = this.task != null ? this.task.getName() + " with id " + this.taskId : this.taskId + " (unknown name)";
        return "Task implementation of " + string + " transitioned with " + this.transition;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.taskId, this.taskId);
        this.writeField(jsonGenerator, (Object)Fields.transition, this.transition);
    }
}

