/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.file;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.file.CaseFileEvent;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Manifest(value="CaseFileEvent")
public class CaseFileItemTransitioned
extends CaseFileEvent
implements StandardEvent<CaseFileItemTransition, CaseFileItem> {
    protected static final Logger logger = LoggerFactory.getLogger(CaseFileItemTransitioned.class);
    private final CaseFileItemTransition transition;
    private final Value<?> value;
    private final State state;

    public CaseFileItemTransitioned(CaseFileItemCollection<?> caseFileItemCollection, State state, CaseFileItemTransition caseFileItemTransition, Value<?> value) {
        super(caseFileItemCollection);
        this.transition = caseFileItemTransition;
        this.value = value;
        this.state = state;
    }

    public CaseFileItemTransitioned(ValueMap valueMap) {
        super(valueMap);
        this.transition = valueMap.readEnum((Object)Fields.transition, CaseFileItemTransition.class);
        this.value = valueMap.get(Fields.value.toString());
        this.state = valueMap.readEnum((Object)Fields.state, State.class);
    }

    @Override
    public CaseFileItem getSource() {
        return this.caseFileItem;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "['" + this.path + "']." + this.getTransition().toString().toLowerCase() + "() ===> " + this.getState();
    }

    @Override
    public CaseFileItemTransition getTransition() {
        return this.transition;
    }

    public State getState() {
        return this.state;
    }

    public Value<?> getValue() {
        return this.value;
    }

    @Override
    protected void updateState(CaseFileItem caseFileItem) {
        caseFileItem.publishTransition(this);
    }

    @Override
    public boolean hasBehavior() {
        return true;
    }

    @Override
    public void runImmediateBehavior() {
        this.caseFileItem.informConnectedEntryCriteria(this);
    }

    @Override
    public void runDelayedBehavior() {
        this.caseFileItem.informConnectedExitCriteria(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseFileEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.transition, this.transition);
        this.writeField(jsonGenerator, (Object)Fields.value, this.value);
        this.writeField(jsonGenerator, (Object)Fields.state, this.state);
    }
}

