/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.expression.DefaultValueEvaluator;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.w3c.dom.Element;

public class ConstraintDefinition
extends CMMNElementDefinition {
    private final ExpressionDefinition expression;
    private final String expressionType;
    private final String contextRef;
    private CaseFileItemDefinition context;
    private Path pathToContext;

    protected ConstraintDefinition(ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition, String string, boolean bl) {
        super(null, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.expression = new ExpressionDefinition(modelDefinition, this, bl);
        this.expressionType = string;
        this.contextRef = "";
    }

    public ConstraintDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.expression = this.parse("condition", ExpressionDefinition.class, true);
        this.contextRef = this.parseAttribute("contextRef", false, new String[0]);
        this.expressionType = element.getTagName();
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        if (this.contextRef.isEmpty()) {
            return;
        }
        this.context = this.getCaseDefinition().findCaseFileItem(this.contextRef);
        if (this.context == null) {
            this.getCaseDefinition().addReferenceError(this.getContextDescription() + " refers to a Case File item with id '" + this.contextRef + "', but the corresponding Case File item cannot be found.");
        } else {
            this.pathToContext = this.context.getPath();
        }
    }

    @Override
    public String getContextDescription() {
        CMMNElementDefinition cMMNElementDefinition = ((XMLElementDefinition)this.getParentElement()).getParentElement() != null ? (CMMNElementDefinition)((XMLElementDefinition)this.getParentElement()).getParentElement() : (CMMNElementDefinition)this.getParentElement();
        String string = cMMNElementDefinition.getType();
        String string2 = cMMNElementDefinition.getId();
        String string3 = cMMNElementDefinition.getName();
        return "The " + this.getType() + " in " + string + " '" + string3 + "' with id '" + string2 + "'";
    }

    public CaseFileItemDefinition getContext() {
        return this.context;
    }

    public CaseFileItem resolveContext(Case case_) {
        if (this.context == null) {
            return null;
        }
        return (CaseFileItem)this.pathToContext.resolve(case_);
    }

    public ExpressionDefinition getExpressionDefinition() {
        return this.expression;
    }

    public boolean evaluate(PlanItem<?> planItem) {
        return this.expression.getEvaluator().evaluateItemControl(planItem, this);
    }

    public boolean isDefault() {
        return this.expression.getEvaluator() instanceof DefaultValueEvaluator;
    }

    @Override
    public String getType() {
        return this.expressionType;
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameConstraint);
    }

    public boolean sameConstraint(ConstraintDefinition constraintDefinition) {
        return this.same(this.expression, constraintDefinition.expression) && this.same(this.context, constraintDefinition.context);
    }
}

