/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.Collection;
import java.util.Objects;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.processtask.definition.ProcessDefinition;

public interface DefinitionElement {
    public String getId();

    public String getName();

    default public boolean isSingletonElement() {
        return false;
    }

    default public String getType() {
        String string = this.getClass().getSimpleName();
        if (string.endsWith("Definition")) {
            return string.substring(0, string.length() - "Definition".length());
        }
        return string;
    }

    default public String getContextDescription() {
        return "";
    }

    public ModelDefinition getModelDefinition();

    default public CaseDefinition getCaseDefinition() {
        return (CaseDefinition)this.getModelDefinition();
    }

    default public ProcessDefinition getProcessDefinition() {
        return (ProcessDefinition)this.getModelDefinition();
    }

    public boolean differs(DefinitionElement var1);

    public boolean equalsWith(Object var1);

    default public boolean sameName(DefinitionElement definitionElement) {
        return this.same(this.getName(), definitionElement.getName());
    }

    default public boolean sameId(DefinitionElement definitionElement) {
        return this.same(this.getId(), definitionElement.getId());
    }

    default public boolean sameIdentifiers(DefinitionElement definitionElement) {
        return this.sameName(definitionElement) && this.sameId(definitionElement);
    }

    default public boolean hasMatchingIdentifier(DefinitionElement definitionElement) {
        return this.sameId(definitionElement) || this.sameName(definitionElement);
    }

    default public boolean hasIdentifier(String string) {
        return this.getId().equals(string) || this.getName().equals(string);
    }

    public static <T extends Z, Z extends DefinitionElement> T findDefinition(T t, Collection<Z> collection) {
        for (DefinitionElement definitionElement : collection) {
            if (!t.hasMatchingIdentifier(definitionElement)) continue;
            return (T)definitionElement;
        }
        return null;
    }

    default public boolean sameClass(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    default public boolean same(String string, String string2) {
        return Objects.equals(string, string2);
    }

    default public <E extends Enum<?>> boolean same(E e, E e2) {
        return Objects.equals(e, e2);
    }

    default public boolean same(boolean bl, boolean bl2) {
        return Objects.equals(bl, bl2);
    }

    default public boolean same(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    default public <E extends DefinitionElement> boolean equalsWith(Object object, DefinitionElementComparer<E> definitionElementComparer) {
        if (!this.sameClass(object)) {
            return false;
        }
        String string = Indenter.indent;
        Indenter.indent = Indenter.indent + "  ";
        boolean bl = definitionElementComparer.match((DefinitionElement)object);
        Indenter.indent = string;
        return bl;
    }

    default public <X extends DefinitionElement> boolean same(Collection<X> collection, Collection<X> collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (DefinitionElement definitionElement : collection) {
            if (DefinitionElement.findDefinition(definitionElement, collection2) != null) continue;
            return false;
        }
        return true;
    }

    default public <X extends DefinitionElement> boolean same(X x, X x2) {
        return x == null && x2 == null || x != null && x2 != null && x.equalsWith(x2);
    }

    public static class Indenter {
        static String indent = "";
    }

    @FunctionalInterface
    public static interface DefinitionElementComparer<X extends DefinitionElement> {
        public boolean match(X var1);
    }
}

