/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.InvalidDefinitionException;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinitionDefinition;
import org.cafienne.cmmn.definition.casefile.ImportDefinition;
import org.cafienne.cmmn.repository.MissingDefinitionException;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DefinitionsDocument
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionsDocument.class);
    private final String sourceDocument;
    private String defaultExpressionLanguage;
    private transient Document document;
    private transient Collection<ModelDefinition> definitions = new ArrayList<ModelDefinition>();
    private transient Collection<CMMNElementDefinition> allElements;
    private transient Collection<String> definitionErrors = new ArrayList<String>();
    private transient Collection<InvalidDefinitionException> fatals = new ArrayList<InvalidDefinitionException>();

    public DefinitionsDocument(Document document) throws InvalidDefinitionException {
        this.document = document;
        this.sourceDocument = XMLHelper.printXMLNode(document);
        this.init();
    }

    private DefinitionsDocument(String string) throws InvalidDefinitionException {
        this.document = null;
        this.sourceDocument = string;
        this.init();
    }

    public static DefinitionsDocument fromSource(String string) {
        try {
            return new DefinitionsDocument(string);
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            throw new RuntimeException("Cannot deserialize DefinitionsDocument from the source", invalidDefinitionException);
        }
    }

    private void init() throws InvalidDefinitionException {
        if (this.document == null) {
            try {
                this.document = XMLHelper.loadXML(this.sourceDocument);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                logger.error("Could not parse a definitions document that has been parsed before?!", (Throwable)exception);
                throw new RuntimeException("Could not parse the XML that was parsable before!?", exception);
            }
        }
        this.defaultExpressionLanguage = this.document.getDocumentElement().getAttribute("expressionLanguage");
        this.allElements = new ArrayList<CMMNElementDefinition>();
        this.parseImports();
        this.parseCaseFileItemDefinitions();
        this.parseProcessDefinitions();
        this.parseCaseDefinitions();
        this.checkForErrors();
        for (ModelDefinition modelDefinition : this.getDefinitions()) {
            modelDefinition.resolveReferences();
        }
        this.checkForErrors();
        for (ModelDefinition modelDefinition : this.getDefinitions()) {
            modelDefinition.validateElement();
        }
        this.checkForErrors();
    }

    public String getDefaultExpressionLanguage() {
        return this.defaultExpressionLanguage;
    }

    private void initAfterDeserialization() {
        try {
            this.init();
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            logger.error("Could not parse a definitions document that has been parsed before?!", (Throwable)invalidDefinitionException);
            throw new RuntimeException("Could not parse the XML that was parsable before!?", invalidDefinitionException);
        }
    }

    public CaseDefinition getFirstCase() throws MissingDefinitionException {
        for (ModelDefinition modelDefinition : this.getDefinitions()) {
            if (!(modelDefinition instanceof CaseDefinition)) continue;
            return (CaseDefinition)modelDefinition;
        }
        throw new MissingDefinitionException("The definitions document does not contain a case definition");
    }

    private void parseImports() {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.getDocument().getDocumentElement(), "import");
        for (Element element : list) {
            ImportDefinition importDefinition = new ImportDefinition(element, this);
            this.getDefinitions().add(importDefinition);
        }
    }

    private void parseCaseFileItemDefinitions() {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.getDocument().getDocumentElement(), "caseFileItemDefinition");
        for (Element element : list) {
            CaseFileItemDefinitionDefinition caseFileItemDefinitionDefinition = new CaseFileItemDefinitionDefinition(element, this);
            this.getDefinitions().add(caseFileItemDefinitionDefinition);
        }
    }

    private void parseProcessDefinitions() {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.getDocument().getDocumentElement(), "process");
        for (Element element : list) {
            ProcessDefinition processDefinition = new ProcessDefinition(element, this);
            this.getDefinitions().add(processDefinition);
        }
    }

    private void parseCaseDefinitions() {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.getDocument().getDocumentElement(), "case");
        for (Element element : list) {
            CaseDefinition caseDefinition = new CaseDefinition(element, this);
            this.getDefinitions().add(caseDefinition);
        }
    }

    private void checkForErrors() throws InvalidDefinitionException {
        if (this.getDefinitions().isEmpty()) {
            this.getDefinitionErrors().add("The definitions document does not contain any definitions");
        }
        if (!this.getDefinitionErrors().isEmpty()) {
            throw new InvalidDefinitionException(this.definitionErrors);
        }
        if (!this.getFatals().isEmpty()) {
            throw this.fatals.iterator().next();
        }
    }

    public String getSource() {
        return this.sourceDocument;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.initAfterDeserialization();
        }
        return this.document;
    }

    private Collection<ModelDefinition> getDefinitions() {
        if (null == this.definitions) {
            this.definitions = new ArrayList<ModelDefinition>();
            this.initAfterDeserialization();
        }
        return this.definitions;
    }

    void addElement(CMMNElementDefinition cMMNElementDefinition) {
        this.allElements.add(cMMNElementDefinition);
    }

    public <T extends CMMNElementDefinition> T findElement(ModelDefinition.ElementMatcher elementMatcher) {
        for (CMMNElementDefinition cMMNElementDefinition : this.allElements) {
            if (!elementMatcher.matches(cMMNElementDefinition)) continue;
            return (T)cMMNElementDefinition;
        }
        return null;
    }

    public <T extends CMMNElementDefinition> T getElement(String string, Class<T> clazz) {
        return this.findElement(cMMNElementDefinition -> cMMNElementDefinition.hasIdentifier(string) && clazz.isAssignableFrom(cMMNElementDefinition.getClass()));
    }

    private Collection<String> getDefinitionErrors() {
        if (null == this.definitionErrors) {
            this.definitionErrors = new ArrayList<String>();
            this.initAfterDeserialization();
        }
        return this.definitionErrors;
    }

    private Collection<InvalidDefinitionException> getFatals() {
        if (null == this.fatals) {
            this.fatals = new ArrayList<InvalidDefinitionException>();
            this.initAfterDeserialization();
        }
        return this.fatals;
    }

    private <T extends ModelDefinition> T getDefinition(Class<T> clazz, String string) {
        for (ModelDefinition modelDefinition : this.getDefinitions()) {
            if (!modelDefinition.hasIdentifier(string) || !clazz.isAssignableFrom(modelDefinition.getClass())) continue;
            ModelDefinition modelDefinition2 = modelDefinition;
            return (T)modelDefinition2;
        }
        return null;
    }

    public CaseDefinition getCaseDefinition(String string) {
        return this.getDefinition(CaseDefinition.class, string);
    }

    public ProcessDefinition getProcessDefinition(String string) {
        return this.getDefinition(ProcessDefinition.class, string);
    }

    public CaseFileItemDefinitionDefinition getCaseFileItemDefinition(String string) {
        return this.getDefinition(CaseFileItemDefinitionDefinition.class, string);
    }

    public ImportDefinition getImportDefinition(String string) {
        return this.getDefinition(ImportDefinition.class, string);
    }

    void addDefinitionError(ModelDefinition modelDefinition, String string) {
        this.getDefinitionErrors().add(modelDefinition.getId() + ": " + string);
    }

    void addFatalError(ModelDefinition modelDefinition, String string, Throwable throwable) {
        this.getFatals().add(new InvalidDefinitionException(modelDefinition.getId() + ": " + string, throwable));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefinitionsDocument definitionsDocument = (DefinitionsDocument)object;
        return this.document == definitionsDocument.document || Objects.equals(this.sourceDocument, definitionsDocument.sourceDocument);
    }

    public int hashCode() {
        return Objects.hash(this.sourceDocument);
    }
}

