/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.expression.CMMNExpressionEvaluator;
import org.cafienne.cmmn.expression.DefaultValueEvaluator;
import org.w3c.dom.Element;

public class ExpressionDefinition
extends CMMNElementDefinition {
    private final String language;
    private final String body;
    private final CMMNExpressionEvaluator evaluator;

    public ExpressionDefinition(ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition, boolean bl) {
        super(null, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.language = "";
        this.body = "";
        this.evaluator = new DefaultValueEvaluator(bl);
    }

    public ExpressionDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.language = this.parseAttribute("language", false, modelDefinition.getDefaultExpressionLanguage());
        this.body = this.parseString("body", true, new String[0]);
        if (this.body == null || this.body.isBlank()) {
            this.getModelDefinition().addDefinitionError(this.getContextDescription() + " has an empty expression");
        }
        this.evaluator = this.instantiateEvaluator();
    }

    private CMMNExpressionEvaluator instantiateEvaluator() {
        String string = "org.cafienne.cmmn.expression." + this.language + ".ExpressionEvaluator";
        try {
            Class<?> clazz = Class.forName(string);
            if (!CMMNExpressionEvaluator.class.isAssignableFrom(clazz)) {
                throw new NoSuchMethodException("The class " + string + " must implement " + CMMNExpressionEvaluator.class.getName() + ", but it does not");
            }
            Constructor<?> constructor = clazz.getConstructor(ExpressionDefinition.class);
            return (CMMNExpressionEvaluator)constructor.newInstance(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getModelDefinition().fatalError("The expression language '" + this.language + "' is not supported", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.getModelDefinition().fatalError("The class " + string + " does not have a constructor that takes " + ExpressionDefinition.class.getName() + " as an argument", noSuchMethodException);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            this.getModelDefinition().fatalError("The class " + string + " cannot be instantiated", exception);
        }
        return null;
    }

    @Override
    public String getContextDescription() {
        if (this.getParentElement() != null) {
            return this.getParentElement().getContextDescription();
        }
        return "The expression with id " + this.getId();
    }

    public String getLanguage() {
        return this.language;
    }

    public String getBody() {
        return this.body;
    }

    public CMMNExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameExpression);
    }

    protected boolean sameExpression(ExpressionDefinition expressionDefinition) {
        return this.same(this.language, expressionDefinition.language) && this.same(this.body, expressionDefinition.body);
    }
}

