/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.cafienne.json.Value;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class InvalidDefinitionException
extends Exception {
    private final Collection<String> definitionErrors;

    InvalidDefinitionException(Collection<String> collection) {
        super("Invalid case definition: " + collection);
        this.definitionErrors = collection;
    }

    public InvalidDefinitionException(String string, Throwable throwable) {
        super(string, throwable);
        this.definitionErrors = new ArrayList<String>();
        this.definitionErrors.add(string);
        this.definitionErrors.add("details: " + throwable.toString());
    }

    @Override
    public String toString() {
        return "Invalid definition: " + this.definitionErrors;
    }

    public Collection<String> getErrors() {
        return this.definitionErrors;
    }

    public Value<?> toJSON() {
        return Value.convert(this.definitionErrors);
    }

    public Document toXML() {
        try {
            Document document = XMLHelper.loadXML("<invalid-definition xmlns=\"org.cafienne\"/>");
            this.definitionErrors.forEach(string -> {
                Element element = (Element)document.getDocumentElement().appendChild(document.createElement("error"));
                element.appendChild(document.createTextNode((String)string));
            });
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

