/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.definition.ItemControlDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.PlanItemStarter;
import org.cafienne.cmmn.definition.extension.workflow.FourEyesDefinition;
import org.cafienne.cmmn.definition.extension.workflow.RendezVousDefinition;
import org.cafienne.cmmn.definition.sentry.EntryCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.ExitCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.ReactivateCriterionDefinition;
import org.cafienne.cmmn.instance.PlanItemType;

public interface ItemDefinition
extends DefinitionElement {
    public ItemControlDefinition getPlanItemControl();

    public PlanItemDefinitionDefinition getPlanItemDefinition();

    default public Collection<EntryCriterionDefinition> getEntryCriteria() {
        return new ArrayList<EntryCriterionDefinition>();
    }

    default public Collection<ReactivateCriterionDefinition> getReactivatingCriteria() {
        return new ArrayList<ReactivateCriterionDefinition>();
    }

    public Collection<ExitCriterionDefinition> getExitCriteria();

    public FourEyesDefinition getFourEyesDefinition();

    public RendezVousDefinition getRendezVousDefinition();

    default public boolean hasFourEyes() {
        return this.getFourEyesDefinition() != null && this.getFourEyesDefinition().hasReferences();
    }

    default public boolean hasRendezVous() {
        return this.getRendezVousDefinition() != null && this.getRendezVousDefinition().hasReferences();
    }

    default public void checkTaskPairingConstraints() {
        if (this.hasRendezVous() && this.hasFourEyes()) {
            Collection<ItemDefinition> collection = this.getRendezVousDefinition().getAllReferences();
            Collection<ItemDefinition> collection2 = this.getFourEyesDefinition().getAllReferences();
            collection2.forEach(itemDefinition -> {
                if (collection.contains(itemDefinition)) {
                    this.getModelDefinition().addDefinitionError(this.getContextDescription() + " has a 4-eyes defined with " + itemDefinition.getName() + ", but also rendez-vous (either directly or indirectly). This is not valid.");
                }
            });
        }
    }

    default public boolean isDiscretionary() {
        return false;
    }

    default public PlanItemType getItemType() {
        return this.getPlanItemDefinition().getItemType();
    }

    default public PlanItemStarter getStarter() {
        return PlanItemStarter.Later(this);
    }

    default public boolean hasExits() {
        return !this.getExitCriteria().isEmpty();
    }
}

