/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.Map;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.parameter.ParameterDefinition;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.parameter.TaskInputParameter;
import org.cafienne.json.Value;
import org.w3c.dom.Element;

public class ParameterMappingDefinition
extends CMMNElementDefinition {
    private final TaskDefinition<?> taskDefinition;
    private final String sourceRef;
    private final String targetRef;
    private final ExpressionDefinition transformation;
    private ParameterDefinition source;
    private ParameterDefinition target;
    private boolean isInputMapping;

    public ParameterMappingDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.taskDefinition = this.findTask(cMMNElementDefinition);
        this.sourceRef = this.parseAttribute("sourceRef", true, new String[0]);
        this.targetRef = this.parseAttribute("targetRef", true, new String[0]);
        this.transformation = this.parse("transformation", ExpressionDefinition.class, false);
        if (this.sourceRef.isBlank() && this.targetRef.isBlank()) {
            this.getModelDefinition().addReferenceError("The parameter mapping '" + this.getDescriptionForError() + "' misses both sourceRef and targetRef attributes");
        } else if (this.sourceRef.isBlank()) {
            this.source = new ParameterDefinition(null, this.getModelDefinition(), this.taskDefinition);
        }
    }

    private TaskDefinition<?> findTask(CMMNElementDefinition cMMNElementDefinition) {
        if (cMMNElementDefinition == null) {
            this.getModelDefinition().addDefinitionError("The parameter mapping '" + this.getId() + "' has no surrounding Task element, and can therefore not be used");
            return null;
        }
        if (cMMNElementDefinition instanceof TaskDefinition) {
            return (TaskDefinition)cMMNElementDefinition;
        }
        return this.findTask((CMMNElementDefinition)cMMNElementDefinition.getParentElement());
    }

    @Override
    public String getContextDescription() {
        String string = this.getParentElement().getType();
        String string2 = ((XMLElementDefinition)this.getParentElement()).getId();
        return "The parameter mapping in " + string + " '" + string2 + "'";
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        Object obj = this.taskDefinition.getImplementationDefinition();
        if (obj == null) {
            return;
        }
        if (this.sourceRef.isBlank()) {
            this.target = this.findParameter(this.taskDefinition.getOutputParameters(), this.targetRef);
            if (this.target == null) {
                String string = "The output mapping '" + this.getDescriptionForError() + "' has targetRef " + this.targetRef + ", but the task does not have this output parameter";
                this.getModelDefinition().addReferenceError(string);
                return;
            }
            if (this.transformation == null) {
                String string = "The output mapping '" + this.getDescriptionForError() + "' has no sourceRef attribute and also no transformation. At least one of them must be present";
                this.getModelDefinition().addReferenceError(string);
                return;
            }
        } else {
            this.source = this.findParameter(this.taskDefinition.getInputParameters(), this.sourceRef);
            if (this.source == null) {
                this.isInputMapping = false;
                this.source = this.findParameter(obj.getOutputParameters(), this.sourceRef);
                this.target = this.findParameter(this.taskDefinition.getOutputParameters(), this.targetRef);
                if (this.source == null) {
                    String string = "The parameter mapping '" + this.getDescriptionForError() + "' has sourceRef " + this.sourceRef + ", but that output parameter is not found in " + this.taskDefinition.getImplementationDefinition().getId();
                    this.getModelDefinition().addReferenceError(string);
                    if (this.target == null && this.findParameter(obj.getInputParameters(), this.targetRef) != null) {
                        this.getModelDefinition().addReferenceError("The parameter mapping '" + this.getDescriptionForError() + "' has invalid sourceRef " + this.sourceRef + ", because the task does not have this output parameter");
                    }
                } else if (this.target == null) {
                    String string = "The parameter mapping '" + this.getDescriptionForError() + "' has targetRef " + this.targetRef + ", but the task does not have this output parameter";
                    this.getModelDefinition().addReferenceError(string);
                }
            } else {
                this.isInputMapping = true;
                this.target = this.findParameter(obj.getInputParameters(), this.targetRef);
                if (this.target == null) {
                    String string = "The input parameter mapping '" + this.getDescriptionForError() + "' has targetRef " + this.targetRef + ", but that input parameter is not found in " + this.taskDefinition.getImplementationDefinition().getId();
                    this.getModelDefinition().addReferenceError(string);
                }
            }
        }
    }

    private String getTaskDefinitionName() {
        CMMNElementDefinition cMMNElementDefinition;
        for (cMMNElementDefinition = (CMMNElementDefinition)this.getParentElement(); cMMNElementDefinition != null && !(cMMNElementDefinition instanceof TaskDefinition); cMMNElementDefinition = (CMMNElementDefinition)cMMNElementDefinition.getParentElement()) {
        }
        if (cMMNElementDefinition != null) {
            return cMMNElementDefinition.getName();
        }
        return "without Task";
    }

    private String getDescriptionForError() {
        String string = this.getTaskDefinitionName();
        String string2 = this.getCaseDefinition().getName();
        return this.getId() + "' in task '" + string + "' in case '" + string2;
    }

    private <T extends ParameterDefinition> ParameterDefinition findParameter(Map<String, T> map, String string) {
        return map.values().stream().filter(parameterDefinition -> parameterDefinition.hasIdentifier(string)).findFirst().orElse(null);
    }

    public ParameterDefinition getSource() {
        return this.source;
    }

    public ParameterDefinition getTarget() {
        return this.target;
    }

    public ExpressionDefinition getTransformation() {
        return this.transformation;
    }

    public boolean hasTransformation() {
        return this.transformation != null && !this.transformation.getBody().isBlank();
    }

    public boolean isInputParameterMapping() {
        return this.isInputMapping;
    }

    public Value<?> transformInput(Task<?> task, TaskInputParameter taskInputParameter) {
        Value<?> value = taskInputParameter.getValue();
        if (this.hasTransformation()) {
            value = this.transformation.getEvaluator().evaluateInputParameterTransformation(task.getCaseInstance(), taskInputParameter, this.target, task);
        }
        return value;
    }

    public Value<?> transformOutput(Task<?> task, Value<?> value) {
        Value<?> value2 = value;
        if (this.hasTransformation()) {
            value2 = this.transformation.getEvaluator().evaluateOutputParameterTransformation(task.getCaseInstance(), value, this.source, this.target, task);
        }
        return value2;
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameMapping);
    }

    public boolean sameMapping(ParameterMappingDefinition parameterMappingDefinition) {
        return this.same(this.isInputMapping, parameterMappingDefinition.isInputMapping) && this.same(this.source, parameterMappingDefinition.source) && this.same(this.target, parameterMappingDefinition.target) && this.same(this.transformation, parameterMappingDefinition.transformation);
    }
}

