/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CasePlanDefinition;
import org.cafienne.cmmn.definition.ItemControlDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.MilestoneDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.PlanItemStarter;
import org.cafienne.cmmn.definition.StageDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.extension.workflow.FourEyesDefinition;
import org.cafienne.cmmn.definition.extension.workflow.RendezVousDefinition;
import org.cafienne.cmmn.definition.sentry.CaseFileItemOnPartDefinition;
import org.cafienne.cmmn.definition.sentry.EntryCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.ExitCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.OnPartDefinition;
import org.cafienne.cmmn.definition.sentry.ReactivateCriterionDefinition;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.w3c.dom.Element;

public class PlanItemDefinition
extends CMMNElementDefinition
implements ItemDefinition {
    private ItemControlDefinition planItemControl;
    private PlanItemDefinitionDefinition definition;
    private final Collection<EntryCriterionDefinition> entryCriteria = new ArrayList<EntryCriterionDefinition>();
    private final Collection<ReactivateCriterionDefinition> reactivationCriteria = new ArrayList<ReactivateCriterionDefinition>();
    private final Collection<ExitCriterionDefinition> exitCriteria = new ArrayList<ExitCriterionDefinition>();
    private final String planItemDefinitionRefValue = this.parseAttribute("definitionRef", true, new String[0]);
    private final FourEyesDefinition fourEyesDefinition;
    private final RendezVousDefinition rendezVousDefinition;
    private PlanItemStarter starter = null;

    public PlanItemDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.parse("entryCriterion", EntryCriterionDefinition.class, this.entryCriteria);
        this.parse("exitCriterion", ExitCriterionDefinition.class, this.exitCriteria);
        this.parseExtension("reactivateCriterion", ReactivateCriterionDefinition.class, this.reactivationCriteria);
        this.planItemControl = this.parse("itemControl", ItemControlDefinition.class, false);
        this.fourEyesDefinition = this.parseExtension("four_eyes", FourEyesDefinition.class);
        this.rendezVousDefinition = this.parseExtension("rendez_vous", RendezVousDefinition.class);
    }

    @Override
    public String toString() {
        return this.definition.getType() + "['" + this.getName() + "']";
    }

    @Override
    public ItemControlDefinition getPlanItemControl() {
        return this.planItemControl;
    }

    @Override
    public PlanItemDefinitionDefinition getPlanItemDefinition() {
        if (this.definition == null) {
            this.definition = this.getCaseDefinition().findPlanItemDefinition(this.planItemDefinitionRefValue);
        }
        return this.definition;
    }

    public StageDefinition getStageDefinition() {
        return (StageDefinition)this.getParentElement();
    }

    @Override
    public Collection<EntryCriterionDefinition> getEntryCriteria() {
        return this.entryCriteria;
    }

    @Override
    public Collection<ReactivateCriterionDefinition> getReactivatingCriteria() {
        return this.reactivationCriteria;
    }

    @Override
    public Collection<ExitCriterionDefinition> getExitCriteria() {
        return this.exitCriteria;
    }

    @Override
    public FourEyesDefinition getFourEyesDefinition() {
        return this.fourEyesDefinition;
    }

    @Override
    public RendezVousDefinition getRendezVousDefinition() {
        return this.rendezVousDefinition;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        if (this.getPlanItemDefinition() == null) {
            this.getCaseDefinition().addReferenceError(this.getContextDescription() + " refers to a definition named " + this.planItemDefinitionRefValue + ", but that definition is not found");
            return;
        }
        if (this.getName().isEmpty()) {
            this.setName(this.getPlanItemDefinition().getName());
        }
    }

    @Override
    protected void validateElement() {
        super.validateElement();
        if (this.planItemControl == null) {
            this.planItemControl = this.definition.getDefaultControl();
        }
        if (this.getPlanItemDefinition() instanceof TaskDefinition && !((TaskDefinition)this.getPlanItemDefinition()).isBlocking() && !this.exitCriteria.isEmpty()) {
            this.getCaseDefinition().addDefinitionError(this.getContextDescription() + " has exit sentries, but these are not allowed for a non blocking task");
        }
        if (!this.planItemControl.getRepetitionRule().isDefault()) {
            if (this.entryCriteria.isEmpty()) {
                if (this.getPlanItemDefinition() instanceof MilestoneDefinition) {
                    this.getCaseDefinition().addDefinitionError(this.getContextDescription() + " has a repetition rule defined, but no entry criteria. This is mandatory.");
                }
            } else if (this.getEntryCriteria().stream().noneMatch(EntryCriterionDefinition::hasOnParts)) {
                this.getCaseDefinition().addDefinitionError(this.getContextDescription() + " has a repetition rule defined, but no entry criteria with at least one on part. This is mandatory.");
            }
        }
        this.checkTaskPairingConstraints();
    }

    @Override
    public PlanItemStarter getStarter() {
        if (this.starter == null) {
            this.starter = this.getEntryCriteria().isEmpty() ? PlanItemStarter.hasNoEntryCriteria(this, this.getStageDefinition().findItemDefinition().getStarter()) : this.getEntryCriteriaStarters();
        }
        return this.starter;
    }

    @Override
    public boolean hasExits() {
        if (this.getExitCriteria().isEmpty()) {
            CMMNElementDefinition cMMNElementDefinition = (CMMNElementDefinition)this.getParentElement();
            if (cMMNElementDefinition instanceof StageDefinition) {
                return ((StageDefinition)cMMNElementDefinition).findItemDefinition().hasExits();
            }
            return false;
        }
        return true;
    }

    private PlanItemStarter getEntryCriteriaStarters() {
        Optional<PlanItemStarter> optional = this.getEntryCriteria().stream().map(this::getEntryCriteriaStarter).filter(PlanItemStarter::isImmediate).findFirst();
        return optional.orElse(PlanItemStarter.Later(this));
    }

    private PlanItemStarter getEntryCriteriaStarter(EntryCriterionDefinition entryCriterionDefinition) {
        Collection<OnPartDefinition> collection = entryCriterionDefinition.getSentryDefinition().getOnParts();
        if (collection.isEmpty()) {
            return PlanItemStarter.hasNoOnParts(this);
        }
        Collection collection2 = collection.stream().map(this::getOnPartStarter).collect(Collectors.toList());
        if (collection2.stream().anyMatch(PlanItemStarter::isLater)) {
            return PlanItemStarter.Later(this);
        }
        return (PlanItemStarter)collection2.stream().findFirst().orElseThrow();
    }

    private PlanItemStarter getOnPartStarter(OnPartDefinition onPartDefinition) {
        if (onPartDefinition instanceof CaseFileItemOnPartDefinition) {
            if (onPartDefinition.asFile().getStandardEvent() == CaseFileItemTransition.Create && this.getCaseDefinition().getInputParameters().values().stream().anyMatch(inputParameterDefinition -> inputParameterDefinition.getBinding().contains(onPartDefinition.asFile().getSourceDefinition()))) {
                return PlanItemStarter.hasImmediateCaseFileCreation(this);
            }
        } else {
            PlanItemStarter planItemStarter;
            PlanItemDefinition planItemDefinition = onPartDefinition.asPlan().getSourceDefinition();
            if (planItemDefinition.getItemType().isMilestone()) {
                return PlanItemStarter.hasImmediateMilestone(this, planItemDefinition.getStarter());
            }
            if (planItemDefinition.getItemType().isTimerEvent() && (planItemStarter = planItemDefinition.getStarter()).isImmediate() && !planItemDefinition.hasExits()) {
                return PlanItemStarter.hasImmediateTimer(this, planItemStarter);
            }
        }
        return PlanItemStarter.Later(this);
    }

    @Override
    public String getContextDescription() {
        String string = this.getPlanItemDefinition() != null ? this.getPlanItemDefinition().getType() : "Plan item";
        return string + " " + this.getName();
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::samePlanItem);
    }

    public boolean samePlanItem(PlanItemDefinition planItemDefinition) {
        return this.sameIdentifiers(planItemDefinition) && this.same(this.planItemControl, planItemDefinition.planItemControl) && this.same(this.definition, planItemDefinition.definition) && this.same(this.entryCriteria, planItemDefinition.entryCriteria) && this.same(this.exitCriteria, planItemDefinition.exitCriteria);
    }

    public boolean samePath(ItemDefinition itemDefinition) {
        if (this == itemDefinition) {
            return true;
        }
        if (itemDefinition == null) {
            return false;
        }
        if (!itemDefinition.getPlanItemDefinition().getClass().equals(this.getPlanItemDefinition().getClass())) {
            return false;
        }
        if (!this.hasMatchingIdentifier(itemDefinition)) {
            return false;
        }
        List<StageDefinition> list = this.getStageChain(this);
        List<StageDefinition> list2 = this.getStageChain(itemDefinition);
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            StageDefinition stageDefinition;
            StageDefinition stageDefinition2 = list.get(i);
            if (stageDefinition2.hasMatchingIdentifier(stageDefinition = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<StageDefinition> getStageChain(ItemDefinition itemDefinition) {
        ArrayList<StageDefinition> arrayList = new ArrayList<StageDefinition>();
        for (Object t = ((XMLElementDefinition)((Object)itemDefinition)).getParentElement(); t != null && !(t instanceof CasePlanDefinition); t = ((XMLElementDefinition)t).getParentElement()) {
            if (!(t instanceof StageDefinition)) continue;
            arrayList.add((StageDefinition)t);
        }
        return arrayList;
    }
}

