/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import org.cafienne.cmmn.definition.ItemDefinition;

public class PlanItemStarter {
    private final Reason reason;
    private final ItemDefinition item;
    private final PlanItemStarter source;

    PlanItemStarter(ItemDefinition itemDefinition, Reason reason) {
        this(itemDefinition, reason, null);
    }

    PlanItemStarter(ItemDefinition itemDefinition, Reason reason, PlanItemStarter planItemStarter) {
        this.item = itemDefinition;
        this.reason = reason;
        this.source = planItemStarter;
    }

    boolean isLater() {
        return !this.isImmediate();
    }

    boolean isImmediate() {
        if (this.source == null) {
            return this.reason.isImmediate;
        }
        return this.source.isImmediate();
    }

    private String report(boolean bl) {
        String string;
        String string2 = string = bl ? " and " : "";
        if (this.source == null) {
            return string + this.item + " " + this.reason;
        }
        return string + this.item + " " + this.reason + "\n" + this.source.report(true);
    }

    public String toString() {
        return this.report(false);
    }

    static PlanItemStarter Later(ItemDefinition itemDefinition) {
        return new PlanItemStarter(itemDefinition, Reason.Later);
    }

    static PlanItemStarter hasImmediateMilestone(ItemDefinition itemDefinition, PlanItemStarter planItemStarter) {
        return new PlanItemStarter(itemDefinition, Reason.ImmediateMilestone, planItemStarter);
    }

    public static PlanItemStarter hasNoEntryCriteria(ItemDefinition itemDefinition, PlanItemStarter planItemStarter) {
        return new PlanItemStarter(itemDefinition, Reason.NoEntryCriteria, planItemStarter);
    }

    public static PlanItemStarter isCasePlan(ItemDefinition itemDefinition) {
        return new PlanItemStarter(itemDefinition, Reason.IsCasePlan);
    }

    public static PlanItemStarter hasNoOnParts(ItemDefinition itemDefinition) {
        return new PlanItemStarter(itemDefinition, Reason.NoOnParts);
    }

    public static PlanItemStarter hasImmediateTimer(ItemDefinition itemDefinition, PlanItemStarter planItemStarter) {
        return new PlanItemStarter(itemDefinition, Reason.ImmediateTimer, planItemStarter);
    }

    public static PlanItemStarter hasImmediateCaseFileCreation(ItemDefinition itemDefinition) {
        return new PlanItemStarter(itemDefinition, Reason.ImmediateCaseFileCreation);
    }

    static enum Reason {
        Later("", false),
        NoEntryCriteria("does not have entry criteria"),
        IsCasePlan("always starts immediately"),
        NoOnParts("has an entry criterion with only an if part expression"),
        ImmediateMilestone("depends on a milestone that occurs immediately"),
        ImmediateTimer("depends on a timer that will not be canceled"),
        ImmediateCaseFileCreation("depends on a case file item that may get created immediately through a case input parameter");

        private final String value;
        public final boolean isImmediate;

        private Reason(String string2, boolean bl) {
            this.isImmediate = bl;
            this.value = string2;
        }

        private Reason(String string2) {
            this(string2, true);
        }

        public String toString() {
            return this.value;
        }
    }
}

