/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class XMLElementDefinition
implements DefinitionElement {
    private static final Logger logger = LoggerFactory.getLogger(XMLElementDefinition.class);
    public static final String EXTENSION_ELEMENTS = "extensionElements";
    public static final String CAFIENNE_NAMESPACE = "org.cafienne";
    public static final String CAFIENNE_IMPLEMENTATION = "implementation";
    private final String id;
    private String name;
    private final ModelDefinition modelDefinition;
    private final XMLElementDefinition parentElement;
    private final Element element;

    protected XMLElementDefinition(Element element, ModelDefinition modelDefinition, XMLElementDefinition xMLElementDefinition, boolean ... blArray) {
        this.element = element;
        this.modelDefinition = modelDefinition;
        this.parentElement = xMLElementDefinition;
        this.id = this.parseAttribute("id", false, new String[0]);
        this.name = this.parseAttribute("name", false, new String[0]);
        if (blArray.length > 0 && blArray[0] && this.getName().isEmpty() && this.getId().isEmpty()) {
            this.getModelDefinition().addDefinitionError("An element of type '" + this.printElement() + "' does not have an identifier " + XMLHelper.printXMLNode(element));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    @Override
    public String getId() {
        if (this.id == null || this.id.isEmpty()) {
            return this.name;
        }
        return this.id;
    }

    @Override
    public ModelDefinition getModelDefinition() {
        return this.modelDefinition;
    }

    public <T extends XMLElementDefinition> T getParentElement() {
        XMLElementDefinition xMLElementDefinition = this.parentElement;
        return (T)xMLElementDefinition;
    }

    public Element getElement() {
        return this.element;
    }

    protected void resolveReferences() {
    }

    protected void validateElement() {
    }

    private <T> T instantiateT(Element element, Class<T> clazz) {
        try {
            if (clazz.equals(String.class)) {
                String string = element.getTextContent();
                return (T)string;
            }
            Constructor<T> constructor = clazz.getConstructor(Element.class, ModelDefinition.class, CMMNElementDefinition.class);
            return constructor.newInstance(element, this.getModelDefinition(), this);
        }
        catch (IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            String string = "The class " + clazz.getName() + " cannot be instantiated";
            this.getModelDefinition().fatalError(string, exception);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "The class " + clazz.getName() + " cannot be accessed";
            this.getModelDefinition().fatalError(string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "The class " + clazz.getName() + " must have a constructor with 3 arguments: org.w3c.dom.Element, Definition and  CMMNElementDefinition";
            this.getModelDefinition().fatalError(string, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            String string = "The class " + clazz.getName() + " cannot be accessed due to a security exception";
            this.getModelDefinition().fatalError(string, securityException);
        }
        return null;
    }

    protected <T> void parse(String string, Class<? extends T> clazz, Collection<T> collection) {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.element, string);
        for (Element element : list) {
            T t = this.instantiateT(element, clazz);
            collection.add(t);
        }
    }

    protected <T extends XMLElementDefinition> void parse(String string, Class<? extends T> clazz, Map<String, T> map) {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.element, string);
        for (Element element : list) {
            XMLElementDefinition xMLElementDefinition = (XMLElementDefinition)this.instantiateT(element, clazz);
            if (xMLElementDefinition == null) continue;
            if (xMLElementDefinition.getName().isEmpty()) {
                this.getModelDefinition().addDefinitionError("The element does not have a name, but it is required in order to be able to look it up\n" + XMLHelper.printXMLNode(element));
            }
            map.put(xMLElementDefinition.getName(), xMLElementDefinition);
        }
    }

    protected <T> T parse(String string, Class<? extends T> clazz, boolean bl) {
        if (this.element == null) {
            if (bl) {
                this.getModelDefinition().addDefinitionError("A '" + string + "' cannot be found in the class " + this.getClass().getName() + ", because there is no XML element defined");
            }
            return null;
        }
        Element element = XMLHelper.getElement(this.element, string);
        if (element != null) {
            return this.instantiateT(element, clazz);
        }
        if (bl) {
            this.getModelDefinition().addDefinitionError("A '" + string + "' cannot be found in the element " + this.printElement() + ", but it is required");
        }
        return null;
    }

    protected String parseString(String string, boolean bl, String ... stringArray) {
        String string2 = XMLHelper.getContent(this.element, string, null);
        if (bl && string2 == null) {
            this.getModelDefinition().addDefinitionError("A '" + string + "' cannot be found in the element " + this.printElement() + ", but it is required");
            return null;
        }
        if (string2 == null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        return string2;
    }

    protected <T> T parseExtension(String string, Class<? extends T> clazz) {
        Element element;
        Element element2 = XMLHelper.getElement(this.element, EXTENSION_ELEMENTS);
        if (element2 != null && (element = XMLHelper.getElementNS(element2, CAFIENNE_NAMESPACE, string)) != null) {
            return this.instantiateT(element, clazz);
        }
        return null;
    }

    protected <T> void parseExtension(String string, Class<? extends T> clazz, Collection<T> collection) {
        Element element = XMLHelper.getElement(this.element, EXTENSION_ELEMENTS);
        if (element != null) {
            List<Element> list = XMLHelper.getElementsNS(element, CAFIENNE_NAMESPACE, string);
            for (Element element2 : list) {
                T t = this.instantiateT(element2, clazz);
                collection.add(t);
            }
        }
    }

    protected <T> void parseGrandChildren(String string, String string2, Class<? extends T> clazz, Collection<T> collection) {
        Element element = XMLHelper.findElement(this.element, string);
        if (element != null) {
            List<Element> list = XMLHelper.getChildrenWithTagName(element, string2);
            for (Element element2 : list) {
                T t = this.instantiateT(element2, clazz);
                collection.add(t);
            }
        }
    }

    protected <T> T getCustomImplementation(Class<? extends T> clazz, boolean bl) {
        Element element = this.getImplementationElement(bl);
        if (element == null) {
            return null;
        }
        String string = element.getAttribute("class");
        if (string.isEmpty()) {
            if (bl) {
                this.getModelDefinition().addDefinitionError("A custom implementation tag does not contain the class attribute in " + this.printElement() + ", but it is required");
                return null;
            }
            return null;
        }
        try {
            Class<?> clazz2 = Class.forName(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new RuntimeException("The implementation class " + string + " must implement " + clazz.getName() + ", but it does not");
            }
            Object obj = this.instantiateT(element, clazz2);
            return (T)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "Cannot find class to parse the custom implementation - " + string;
            this.getModelDefinition().fatalError(string2, classNotFoundException);
        }
        catch (SecurityException securityException) {
            String string3 = "The class " + string + " cannot be accessed due to a security exception";
            this.getModelDefinition().fatalError(string3, securityException);
        }
        return null;
    }

    protected Element getImplementationElement(boolean bl) {
        Element element = XMLHelper.getElement(this.element, EXTENSION_ELEMENTS);
        if (element == null) {
            if (bl) {
                this.getModelDefinition().addDefinitionError("'extensionElements' tag is not found in " + this.printElement() + ", but it is required");
                return null;
            }
            return null;
        }
        Element element2 = XMLHelper.getElementNS(element, CAFIENNE_NAMESPACE, CAFIENNE_IMPLEMENTATION);
        if (element2 == null && bl) {
            this.getModelDefinition().addDefinitionError("A custom implementation tag is not found in " + this.printElement() + "/extensionElements in org.cafienne namespace, but it is required");
        }
        return element2;
    }

    protected boolean getImplementationAttribute(String string) {
        Element element = this.getImplementationElement(false);
        if (element == null) {
            return false;
        }
        String string2 = element.getAttribute(string);
        return string2.equalsIgnoreCase("true");
    }

    protected String parseAttribute(String string, boolean bl, String ... stringArray) {
        if (this.element != null && this.element.hasAttribute(string)) {
            return this.element.getAttribute(string);
        }
        if (bl) {
            if (this.element == null) {
                this.getModelDefinition().addDefinitionError("The attribute " + string + " cannot be found, because an XML element is missing in " + this.getType());
            } else {
                this.getModelDefinition().addDefinitionError("The attribute " + string + " is missing from the element " + XMLHelper.printXMLNode(this.element));
            }
        }
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    protected String printElement() {
        String string = XMLHelper.printXMLNode(this.element.cloneNode(false));
        string = string.replace("\n", "");
        string = string.replace("\r", "");
        return string;
    }

    @Override
    public final boolean differs(DefinitionElement definitionElement) {
        return !this.equalsWith(definitionElement);
    }

    protected boolean notYetImplemented() {
        logger.error("Definition comparison is not yet implemented on definition elements of type " + this.getClass().getName());
        return false;
    }
}

