/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.extension.workflow;

import java.util.LinkedHashMap;
import java.util.Map;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.HumanTaskDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.ParameterMappingDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.extension.workflow.AssignmentDefinition;
import org.cafienne.cmmn.definition.extension.workflow.DueDateDefinition;
import org.cafienne.cmmn.definition.extension.workflow.TaskModelDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.definition.parameter.OutputParameterDefinition;
import org.cafienne.cmmn.definition.task.TaskImplementationContract;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.instance.WorkflowTask;
import org.w3c.dom.Element;

public class WorkflowTaskDefinition
extends CMMNElementDefinition
implements TaskImplementationContract {
    private final Map<String, InputParameterDefinition> inputParameters = new LinkedHashMap<String, InputParameterDefinition>();
    private final Map<String, OutputParameterDefinition> outputParameters = new LinkedHashMap<String, OutputParameterDefinition>();
    private final TaskModelDefinition taskModel;
    private final DueDateDefinition dueDate;
    private final AssignmentDefinition assignment;

    public WorkflowTaskDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.parse("input", InputParameterDefinition.class, this.inputParameters);
        this.parse("output", OutputParameterDefinition.class, this.outputParameters);
        this.assignment = this.parse("assignment", AssignmentDefinition.class, false);
        this.dueDate = this.parse("duedate", DueDateDefinition.class, false);
        this.taskModel = this.parse("task-model", TaskModelDefinition.class, false);
        TaskDefinition taskDefinition = (TaskDefinition)this.getParentElement();
        this.parse("parameterMapping", ParameterMappingDefinition.class, taskDefinition.getParameterMappings());
    }

    public WorkflowTask createInstance(HumanTask humanTask) {
        return new WorkflowTask(this, humanTask);
    }

    @Override
    public Map<String, InputParameterDefinition> getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public Map<String, OutputParameterDefinition> getOutputParameters() {
        return this.outputParameters;
    }

    public TaskModelDefinition getTaskModel() {
        return this.taskModel;
    }

    public AssignmentDefinition getAssignmentExpression() {
        return this.assignment;
    }

    public DueDateDefinition getDueDateExpression() {
        return this.dueDate;
    }

    public static WorkflowTaskDefinition createEmptyDefinition(HumanTaskDefinition humanTaskDefinition) {
        Element element = humanTaskDefinition.getElement().getOwnerDocument().createElementNS("org.cafienne", "implementation");
        return new WorkflowTaskDefinition(element, humanTaskDefinition.getModelDefinition(), humanTaskDefinition);
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameWorkflow);
    }

    public boolean sameWorkflow(WorkflowTaskDefinition workflowTaskDefinition) {
        return this.same(this.taskModel, workflowTaskDefinition.taskModel) && this.same(this.dueDate, workflowTaskDefinition.dueDate) && this.same(this.assignment, workflowTaskDefinition.assignment) && this.same(this.inputParameters.values(), workflowTaskDefinition.inputParameters.values()) && this.same(this.outputParameters.values(), workflowTaskDefinition.outputParameters.values());
    }
}

