/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.sentry;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.sentry.ExitCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.OnPartDefinition;
import org.cafienne.cmmn.definition.sentry.SentryDefinition;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.PlanItemOnPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PlanItemOnPartDefinition
extends OnPartDefinition {
    private static final Logger logger = LoggerFactory.getLogger(PlanItemOnPartDefinition.class);
    private final Transition standardEvent;
    private final String sourceRef;
    private final String exitCriterionRef;
    private PlanItemDefinition source;
    private ExitCriterionDefinition exitCriterion;

    public PlanItemOnPartDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        String string = this.parseString("standardEvent", true, new String[0]);
        this.standardEvent = Transition.getEnum(string);
        if (this.standardEvent == null) {
            this.getCaseDefinition().addDefinitionError("A standard event named " + string + " does not exist for plan items");
        }
        this.sourceRef = this.parseAttribute("sourceRef", true, new String[0]);
        String string2 = this.parseAttribute("sentryRef", false, new String[0]);
        if (!string2.isEmpty()) {
            logger.warn("Converting old sentry ref '" + string2 + "' in on part. Please upgrade the model.");
        }
        this.exitCriterionRef = this.parseAttribute("exitCriterionRef", false, string2);
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.source = this.getCaseDefinition().findPlanItem(this, this.sourceRef);
        if (this.source == null) {
            this.getCaseDefinition().addReferenceError("A plan item with name '" + this.sourceRef + "' is referenced from exitCriterion " + ((XMLElementDefinition)this.getParentElement()).getName() + ", but it does not exist in the case plan model");
        }
        if (!this.exitCriterionRef.isEmpty()) {
            Object t = this.getCaseDefinition().getElement(this.exitCriterionRef);
            if (t instanceof ExitCriterionDefinition) {
                this.exitCriterion = (ExitCriterionDefinition)t;
            } else if (t instanceof SentryDefinition) {
                this.exitCriterion = (ExitCriterionDefinition)this.getCaseDefinition().findElement(cMMNElementDefinition2 -> cMMNElementDefinition2 instanceof ExitCriterionDefinition && ((ExitCriterionDefinition)cMMNElementDefinition2).getSentryDefinition() == t);
            }
            if (this.exitCriterion == null) {
                this.getCaseDefinition().addReferenceError("The exit criterion with name '" + this.exitCriterionRef + "' is referenced from the entry criterion " + ((XMLElementDefinition)this.getParentElement()).getName() + " in plan item " + ((XMLElementDefinition)this.getParentElement()).getName() + ", but it does not exist in the case plan model");
                return;
            }
            if (this.standardEvent != Transition.Exit) {
                this.getModelDefinition().addDefinitionError("The onPart in exitCriterion " + ((XMLElementDefinition)this.getParentElement()).getName() + " must have 'exit' as its standard event, since it has a exitCriterionRef");
            }
        }
    }

    @Override
    public String getContextDescription() {
        return this.source.getPlanItemDefinition().getType() + "[" + this.source.getName() + "]." + this.standardEvent;
    }

    public Transition getStandardEvent() {
        return this.standardEvent;
    }

    @Override
    public PlanItemDefinition getSourceDefinition() {
        return this.source;
    }

    @Override
    public PlanItemOnPartDefinition asPlan() {
        return this;
    }

    public ExitCriterionDefinition getRelatedExitCriterion() {
        return this.exitCriterion;
    }

    public PlanItemOnPart createInstance(Criterion<?> criterion) {
        return new PlanItemOnPart(criterion, this);
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameOnPart);
    }

    public boolean sameOnPart(PlanItemOnPartDefinition planItemOnPartDefinition) {
        return this.same(this.standardEvent, planItemOnPartDefinition.standardEvent) && this.source.sameIdentifiers(planItemOnPartDefinition.source) && this.same(this.exitCriterion, planItemOnPartDefinition.exitCriterion);
    }
}

